/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.SrvcOrdTmplItemUserStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
 * SrvcOrdTmplItemUserStatus} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SrvcOrdTmplItemUserStatusByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcOrdTmplItemUserStatusByKeyFluentHelper, SrvcOrdTmplItemUserStatus, SrvcOrdTmplItemUserStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
     * SrvcOrdTmplItemUserStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param srvcOrdTmplItmUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcOrdTmplItemUserStatus}
     * @param serviceOrderTemplate
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcOrdTmplItemUserStatus}
     * @param serviceOrderTemplateItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SrvcOrdTmplItemUserStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String srvcOrdTmplItmUserStatus )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrderTemplate", serviceOrderTemplate);
        this.key.put("ServiceOrderTemplateItem", serviceOrderTemplateItem);
        this.key.put("SrvcOrdTmplItmUserStatus", srvcOrdTmplItmUserStatus);
    }

    @Override
    @Nonnull
    protected Class<SrvcOrdTmplItemUserStatus> getEntityClass()
    {
        return SrvcOrdTmplItemUserStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
