/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.SrvcOrdTmplPartnerAddressSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
 * SrvcOrdTmplPartnerAddress} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SrvcOrdTmplPartnerAddressByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcOrdTmplPartnerAddressByKeyFluentHelper, SrvcOrdTmplPartnerAddress, SrvcOrdTmplPartnerAddressSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
     * SrvcOrdTmplPartnerAddress} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcOrdTmplPartnerAddress}
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrderTemplate
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcOrdTmplPartnerAddress}
     */
    public SrvcOrdTmplPartnerAddressByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrderTemplate,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrderTemplate", serviceOrderTemplate);
        this.key.put("CustMgmtPartnerFunction", custMgmtPartnerFunction);
        this.key.put("CustMgmtBusinessPartner", custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    protected Class<SrvcOrdTmplPartnerAddress> getEntityClass()
    {
        return SrvcOrdTmplPartnerAddress.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
