/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
 * SrvcOrdTmplPartnerAddress} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class SrvcOrdTmplPartnerAddressUpdateFluentHelper
    extends
    FluentHelperUpdate<SrvcOrdTmplPartnerAddressUpdateFluentHelper, SrvcOrdTmplPartnerAddress>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
     * SrvcOrdTmplPartnerAddress} entity object that will be updated in the S/4HANA system.
     *
     */
    private final SrvcOrdTmplPartnerAddress entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
     * SrvcOrdTmplPartnerAddress} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The SrvcOrdTmplPartnerAddress to take the updated values from.
     */
    public SrvcOrdTmplPartnerAddressUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final SrvcOrdTmplPartnerAddress entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected SrvcOrdTmplPartnerAddress getEntity()
    {
        return entity;
    }

}
