/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ServiceOrderTemplateServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService ServiceOrderTemplateService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultServiceOrderTemplateServiceBatch
    extends
    BatchFluentHelperBasic<ServiceOrderTemplateServiceBatch, ServiceOrderTemplateServiceBatchChangeSet>
    implements
    ServiceOrderTemplateServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultServiceOrderTemplateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceOrderTemplateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultServiceOrderTemplateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceOrderTemplateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultServiceOrderTemplateServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultServiceOrderTemplateServiceBatchChangeSet(this, service);
    }

}
