/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus;

/**
 * Implementation of the {@link ServiceOrderTemplateServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService ServiceOrderTemplateService}.
 *
 */
public class DefaultServiceOrderTemplateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ServiceOrderTemplateServiceBatch, ServiceOrderTemplateServiceBatchChangeSet>
    implements
    ServiceOrderTemplateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService service;

    @SuppressWarnings( "deprecation" )
    DefaultServiceOrderTemplateServiceBatchChangeSet(
        @Nonnull final DefaultServiceOrderTemplateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultServiceOrderTemplateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTemplate(
        @Nonnull final ServiceOrderTemplate serviceOrderTemplate )
    {
        return addRequestCreate(service::createServiceOrderTemplate, serviceOrderTemplate);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateServiceOrderTemplate(
        @Nonnull final ServiceOrderTemplate serviceOrderTemplate )
    {
        return addRequestUpdate(service::updateServiceOrderTemplate, serviceOrderTemplate);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTemplateItem(
        @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem )
    {
        return addRequestCreate(service::createServiceOrderTemplateItem, serviceOrderTemplateItem);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateServiceOrderTemplateItem(
        @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem )
    {
        return addRequestUpdate(service::updateServiceOrderTemplateItem, serviceOrderTemplateItem);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteServiceOrderTemplateItem(
        @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem )
    {
        return addRequestDelete(service::deleteServiceOrderTemplateItem, serviceOrderTemplateItem);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTmplItemRefObj(
        @Nonnull final ServiceOrderTmplItemRefObj serviceOrderTmplItemRefObj )
    {
        return addRequestCreate(service::createServiceOrderTmplItemRefObj, serviceOrderTmplItemRefObj);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteServiceOrderTmplItemRefObj(
        @Nonnull final ServiceOrderTmplItemRefObj serviceOrderTmplItemRefObj )
    {
        return addRequestDelete(service::deleteServiceOrderTmplItemRefObj, serviceOrderTmplItemRefObj);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTmplItemText(
        @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText )
    {
        return addRequestCreate(service::createServiceOrderTmplItemText, serviceOrderTmplItemText);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateServiceOrderTmplItemText(
        @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText )
    {
        return addRequestUpdate(service::updateServiceOrderTmplItemText, serviceOrderTmplItemText);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteServiceOrderTmplItemText(
        @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText )
    {
        return addRequestDelete(service::deleteServiceOrderTmplItemText, serviceOrderTmplItemText);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTmplPersonResp(
        @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp )
    {
        return addRequestCreate(service::createServiceOrderTmplPersonResp, serviceOrderTmplPersonResp);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateServiceOrderTmplPersonResp(
        @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp )
    {
        return addRequestUpdate(service::updateServiceOrderTmplPersonResp, serviceOrderTmplPersonResp);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteServiceOrderTmplPersonResp(
        @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp )
    {
        return addRequestDelete(service::deleteServiceOrderTmplPersonResp, serviceOrderTmplPersonResp);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTmplRefObject(
        @Nonnull final ServiceOrderTmplRefObject serviceOrderTmplRefObject )
    {
        return addRequestCreate(service::createServiceOrderTmplRefObject, serviceOrderTmplRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteServiceOrderTmplRefObject(
        @Nonnull final ServiceOrderTmplRefObject serviceOrderTmplRefObject )
    {
        return addRequestDelete(service::deleteServiceOrderTmplRefObject, serviceOrderTmplRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createServiceOrderTmplText(
        @Nonnull final ServiceOrderTmplText serviceOrderTmplText )
    {
        return addRequestCreate(service::createServiceOrderTmplText, serviceOrderTmplText);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateServiceOrderTmplText(
        @Nonnull final ServiceOrderTmplText serviceOrderTmplText )
    {
        return addRequestUpdate(service::updateServiceOrderTmplText, serviceOrderTmplText);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteServiceOrderTmplText(
        @Nonnull final ServiceOrderTmplText serviceOrderTmplText )
    {
        return addRequestDelete(service::deleteServiceOrderTmplText, serviceOrderTmplText);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplAppointment(
        @Nonnull final SrvcOrdTmplAppointment srvcOrdTmplAppointment )
    {
        return addRequestCreate(service::createSrvcOrdTmplAppointment, srvcOrdTmplAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplAppointment(
        @Nonnull final SrvcOrdTmplAppointment srvcOrdTmplAppointment )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplAppointment, srvcOrdTmplAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplDuration(
        @Nonnull final SrvcOrdTmplDuration srvcOrdTmplDuration )
    {
        return addRequestCreate(service::createSrvcOrdTmplDuration, srvcOrdTmplDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplDuration(
        @Nonnull final SrvcOrdTmplDuration srvcOrdTmplDuration )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplDuration, srvcOrdTmplDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplItemAppointment(
        @Nonnull final SrvcOrdTmplItemAppointment srvcOrdTmplItemAppointment )
    {
        return addRequestCreate(service::createSrvcOrdTmplItemAppointment, srvcOrdTmplItemAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplItemAppointment(
        @Nonnull final SrvcOrdTmplItemAppointment srvcOrdTmplItemAppointment )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplItemAppointment, srvcOrdTmplItemAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplItemDuration(
        @Nonnull final SrvcOrdTmplItemDuration srvcOrdTmplItemDuration )
    {
        return addRequestCreate(service::createSrvcOrdTmplItemDuration, srvcOrdTmplItemDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplItemDuration(
        @Nonnull final SrvcOrdTmplItemDuration srvcOrdTmplItemDuration )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplItemDuration, srvcOrdTmplItemDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplItemPartner(
        @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner )
    {
        return addRequestCreate(service::createSrvcOrdTmplItemPartner, srvcOrdTmplItemPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplItemPartner(
        @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplItemPartner, srvcOrdTmplItemPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteSrvcOrdTmplItemPartner(
        @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner )
    {
        return addRequestDelete(service::deleteSrvcOrdTmplItemPartner, srvcOrdTmplItemPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplItemUserStatus(
        @Nonnull final SrvcOrdTmplItemUserStatus srvcOrdTmplItemUserStatus )
    {
        return addRequestCreate(service::createSrvcOrdTmplItemUserStatus, srvcOrdTmplItemUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteSrvcOrdTmplItemUserStatus(
        @Nonnull final SrvcOrdTmplItemUserStatus srvcOrdTmplItemUserStatus )
    {
        return addRequestDelete(service::deleteSrvcOrdTmplItemUserStatus, srvcOrdTmplItemUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplItmPartnerAddress(
        @Nonnull final SrvcOrdTmplItmPartnerAddress srvcOrdTmplItmPartnerAddress )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplItmPartnerAddress, srvcOrdTmplItmPartnerAddress);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplPartner(
        @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner )
    {
        return addRequestCreate(service::createSrvcOrdTmplPartner, srvcOrdTmplPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplPartner(
        @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplPartner, srvcOrdTmplPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteSrvcOrdTmplPartner(
        @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner )
    {
        return addRequestDelete(service::deleteSrvcOrdTmplPartner, srvcOrdTmplPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet updateSrvcOrdTmplPartnerAddress(
        @Nonnull final SrvcOrdTmplPartnerAddress srvcOrdTmplPartnerAddress )
    {
        return addRequestUpdate(service::updateSrvcOrdTmplPartnerAddress, srvcOrdTmplPartnerAddress);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet createSrvcOrdTmplUserStatus(
        @Nonnull final SrvcOrdTmplUserStatus srvcOrdTmplUserStatus )
    {
        return addRequestCreate(service::createSrvcOrdTmplUserStatus, srvcOrdTmplUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderTemplateServiceBatchChangeSet deleteSrvcOrdTmplUserStatus(
        @Nonnull final SrvcOrdTmplUserStatus srvcOrdTmplUserStatus )
    {
        return addRequestDelete(service::deleteSrvcOrdTmplUserStatus, srvcOrdTmplUserStatus);
    }

}
