/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService
 * ServiceOrderTemplateService}.
 *
 */
public interface ServiceOrderTemplateServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ServiceOrderTemplateServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ServiceOrderTemplateServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate
     * ServiceOrderTemplate} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTemplate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate
     *            ServiceOrderTemplate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTemplate( @Nonnull final ServiceOrderTemplate serviceOrderTemplate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate
     * ServiceOrderTemplate} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTemplate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate
     *            ServiceOrderTemplate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateServiceOrderTemplate( @Nonnull final ServiceOrderTemplate serviceOrderTemplate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
     * ServiceOrderTemplateItem} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTemplateItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
     *            ServiceOrderTemplateItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTemplateItem( @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
     * ServiceOrderTemplateItem} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTemplateItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
     *            ServiceOrderTemplateItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateServiceOrderTemplateItem( @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
     * ServiceOrderTemplateItem} entity in the S/4HANA system.
     *
     * @param serviceOrderTemplateItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
     *            ServiceOrderTemplateItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteServiceOrderTemplateItem( @Nonnull final ServiceOrderTemplateItem serviceOrderTemplateItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj
     * ServiceOrderTmplItemRefObj} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplItemRefObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj
     *            ServiceOrderTmplItemRefObj} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTmplItemRefObj( @Nonnull final ServiceOrderTmplItemRefObj serviceOrderTmplItemRefObj );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj
     * ServiceOrderTmplItemRefObj} entity in the S/4HANA system.
     *
     * @param serviceOrderTmplItemRefObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj
     *            ServiceOrderTmplItemRefObj} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteServiceOrderTmplItemRefObj( @Nonnull final ServiceOrderTmplItemRefObj serviceOrderTmplItemRefObj );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
     * ServiceOrderTmplItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
     *            ServiceOrderTmplItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTmplItemText( @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
     * ServiceOrderTmplItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
     *            ServiceOrderTmplItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateServiceOrderTmplItemText( @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
     * ServiceOrderTmplItemText} entity in the S/4HANA system.
     *
     * @param serviceOrderTmplItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
     *            ServiceOrderTmplItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteServiceOrderTmplItemText( @Nonnull final ServiceOrderTmplItemText serviceOrderTmplItemText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp
     * ServiceOrderTmplPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp
     *            ServiceOrderTmplPersonResp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTmplPersonResp( @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp
     * ServiceOrderTmplPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp
     *            ServiceOrderTmplPersonResp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateServiceOrderTmplPersonResp( @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp
     * ServiceOrderTmplPersonResp} entity in the S/4HANA system.
     *
     * @param serviceOrderTmplPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplPersonResp
     *            ServiceOrderTmplPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteServiceOrderTmplPersonResp( @Nonnull final ServiceOrderTmplPersonResp serviceOrderTmplPersonResp );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
     * ServiceOrderTmplRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
     *            ServiceOrderTmplRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTmplRefObject( @Nonnull final ServiceOrderTmplRefObject serviceOrderTmplRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
     * ServiceOrderTmplRefObject} entity in the S/4HANA system.
     *
     * @param serviceOrderTmplRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
     *            ServiceOrderTmplRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteServiceOrderTmplRefObject( @Nonnull final ServiceOrderTmplRefObject serviceOrderTmplRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText
     * ServiceOrderTmplText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText
     *            ServiceOrderTmplText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createServiceOrderTmplText( @Nonnull final ServiceOrderTmplText serviceOrderTmplText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText
     * ServiceOrderTmplText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderTmplText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText
     *            ServiceOrderTmplText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateServiceOrderTmplText( @Nonnull final ServiceOrderTmplText serviceOrderTmplText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText
     * ServiceOrderTmplText} entity in the S/4HANA system.
     *
     * @param serviceOrderTmplText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplText
     *            ServiceOrderTmplText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteServiceOrderTmplText( @Nonnull final ServiceOrderTmplText serviceOrderTmplText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment
     * SrvcOrdTmplAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment
     *            SrvcOrdTmplAppointment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplAppointment( @Nonnull final SrvcOrdTmplAppointment srvcOrdTmplAppointment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment
     * SrvcOrdTmplAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplAppointment
     *            SrvcOrdTmplAppointment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplAppointment( @Nonnull final SrvcOrdTmplAppointment srvcOrdTmplAppointment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration
     * SrvcOrdTmplDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration
     *            SrvcOrdTmplDuration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplDuration( @Nonnull final SrvcOrdTmplDuration srvcOrdTmplDuration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration
     * SrvcOrdTmplDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration
     *            SrvcOrdTmplDuration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplDuration( @Nonnull final SrvcOrdTmplDuration srvcOrdTmplDuration );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment
     * SrvcOrdTmplItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment
     *            SrvcOrdTmplItemAppointment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplItemAppointment( @Nonnull final SrvcOrdTmplItemAppointment srvcOrdTmplItemAppointment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment
     * SrvcOrdTmplItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemAppointment
     *            SrvcOrdTmplItemAppointment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplItemAppointment( @Nonnull final SrvcOrdTmplItemAppointment srvcOrdTmplItemAppointment );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration
     * SrvcOrdTmplItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration
     *            SrvcOrdTmplItemDuration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplItemDuration( @Nonnull final SrvcOrdTmplItemDuration srvcOrdTmplItemDuration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration
     * SrvcOrdTmplItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemDuration
     *            SrvcOrdTmplItemDuration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplItemDuration( @Nonnull final SrvcOrdTmplItemDuration srvcOrdTmplItemDuration );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     * SrvcOrdTmplItemPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     *            SrvcOrdTmplItemPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplItemPartner( @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     * SrvcOrdTmplItemPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     *            SrvcOrdTmplItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplItemPartner( @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     * SrvcOrdTmplItemPartner} entity in the S/4HANA system.
     *
     * @param srvcOrdTmplItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     *            SrvcOrdTmplItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteSrvcOrdTmplItemPartner( @Nonnull final SrvcOrdTmplItemPartner srvcOrdTmplItemPartner );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
     * SrvcOrdTmplItemUserStatus} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
     *            SrvcOrdTmplItemUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplItemUserStatus( @Nonnull final SrvcOrdTmplItemUserStatus srvcOrdTmplItemUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
     * SrvcOrdTmplItemUserStatus} entity in the S/4HANA system.
     *
     * @param srvcOrdTmplItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
     *            SrvcOrdTmplItemUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteSrvcOrdTmplItemUserStatus( @Nonnull final SrvcOrdTmplItemUserStatus srvcOrdTmplItemUserStatus );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddress
     * SrvcOrdTmplItmPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplItmPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItmPartnerAddress
     *            SrvcOrdTmplItmPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplItmPartnerAddress( @Nonnull final SrvcOrdTmplItmPartnerAddress srvcOrdTmplItmPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner
     * SrvcOrdTmplPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner
     *            SrvcOrdTmplPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplPartner( @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner
     * SrvcOrdTmplPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner
     *            SrvcOrdTmplPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplPartner( @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner
     * SrvcOrdTmplPartner} entity in the S/4HANA system.
     *
     * @param srvcOrdTmplPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartner
     *            SrvcOrdTmplPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteSrvcOrdTmplPartner( @Nonnull final SrvcOrdTmplPartner srvcOrdTmplPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
     * SrvcOrdTmplPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
     *            SrvcOrdTmplPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        updateSrvcOrdTmplPartnerAddress( @Nonnull final SrvcOrdTmplPartnerAddress srvcOrdTmplPartnerAddress );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus
     * SrvcOrdTmplUserStatus} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdTmplUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus
     *            SrvcOrdTmplUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        createSrvcOrdTmplUserStatus( @Nonnull final SrvcOrdTmplUserStatus srvcOrdTmplUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus
     * SrvcOrdTmplUserStatus} entity in the S/4HANA system.
     *
     * @param srvcOrdTmplUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus
     *            SrvcOrdTmplUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderTemplateServiceBatchChangeSet
        deleteSrvcOrdTmplUserStatus( @Nonnull final SrvcOrdTmplUserStatus srvcOrdTmplUserStatus );

}
