/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem
 * ServiceOrderTemplateItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTemplateItemField
 * ServiceOrderTemplateItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTemplateItemLink
 * ServiceOrderTemplateItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SERVICE_ORDER_TEMPLATE_ITEM
 * SERVICE_ORDER_TEMPLATE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SERVICE_ORDER_TEMPLATE_ITEM_UUID
 * SERVICE_ORDER_TEMPLATE_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_ORD_TMPL_ITM_DESCRIPTION
 * SRVC_ORD_TMPL_ITM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SERVICE_OBJECT_TYPE
 * SERVICE_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SERVICE_DOCUMENT_ITEM_OBJECT_TYPE
 * SERVICE_DOCUMENT_ITEM_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_ORD_TMPL_ITM_CATEGORY
 * SRVC_ORD_TMPL_ITM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_DOC_ITM_VALDTY_START_DATE_TIME
 * SRVC_DOC_ITM_VALDTY_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_DOC_ITM_VALDTY_END_DATE_TIME
 * SRVC_DOC_ITM_VALDTY_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_ORD_TMPL_ITM_IS_RELEASED
 * SRVC_ORD_TMPL_ITM_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#PARENT_SERVICE_ORDER_TEMPLATE_ITEM
 * PARENT_SERVICE_ORDER_TEMPLATE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_ORD_TMPL_ITM_IS_COMPLETED
 * SRVC_ORD_TMPL_ITM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_DOC_ITM_PART_REFERENCE_ITEM
 * SRVC_DOC_ITM_PART_REFERENCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_DOC_ITM_APPT_REFERENCE_ITEM
 * SRVC_DOC_ITM_APPT_REFERENCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#SRVC_DOC_ITM_APPT_REF_OBJECT_UUID
 * SRVC_DOC_ITM_APPT_REF_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_APPOINTMENT
 * TO_APPOINTMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_DURATION
 * TO_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_REFERENCE_OBJECT
 * TO_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_SERVICE_ORDER_TEMPLATE
 * TO_SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_SRVC_ORD_TMPL_ITEM_USER_STATUS
 * TO_SRVC_ORD_TMPL_ITEM_USER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplateItem#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceOrderTemplateItemSelectable extends EntitySelectable<ServiceOrderTemplateItem>
{

}
