/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate
 * ServiceOrderTemplate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTemplateField
 * ServiceOrderTemplateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTemplateLink
 * ServiceOrderTemplateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_ORDER_TEMPLATE_UUID
 * SERVICE_ORDER_TEMPLATE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_ORDER_TEMPLATE_TYPE
 * SERVICE_ORDER_TEMPLATE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_OBJECT_TYPE
 * SERVICE_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SRVC_ORD_TMPL_DESCRIPTION
 * SRVC_ORD_TMPL_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_DOCUMENT_TEMPLATE_TYPE
 * SERVICE_DOCUMENT_TEMPLATE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SRVC_DOC_TEMPLATE_SEARCH_TERM_TEXT
 * SRVC_DOC_TEMPLATE_SEARCH_TERM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_DOCUMENT_PRIORITY
 * SERVICE_DOCUMENT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SRVC_DOC_TMPL_VALDTY_START_DATE_TIME
 * SRVC_DOC_TMPL_VALDTY_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SRVC_DOC_TMPL_VALDTY_END_DATE_TIME
 * SRVC_DOC_TMPL_VALDTY_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SRVC_ORD_TMPL_IS_RELEASED
 * SRVC_ORD_TMPL_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SRVC_ORD_TMPL_IS_COMPLETED
 * SRVC_ORD_TMPL_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_ORDER_TYPE
 * SERVICE_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SERVICE_DOCUMENT_TYPE
 * SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_APPOINTMENT
 * TO_APPOINTMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_DURATION
 * TO_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_PERSON_RESPONSIBLE
 * TO_PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_REFERENCE_OBJECT
 * TO_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_SRVC_ORD_TMPL_USER_STATUS
 * TO_SRVC_ORD_TMPL_USER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTemplate#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceOrderTemplateSelectable extends EntitySelectable<ServiceOrderTemplate>
{

}
