/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj
 * ServiceOrderTmplItemRefObj}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTmplItemRefObjField
 * ServiceOrderTmplItemRefObjField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTmplItemRefObjLink
 * ServiceOrderTmplItemRefObjLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj#SERVICE_ORDER_TEMPLATE_ITEM
 * SERVICE_ORDER_TEMPLATE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj#SERVICE_REFERENCE_EQUIPMENT
 * SERVICE_REFERENCE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj#SERVICE_REF_FUNCTIONAL_LOCATION
 * SERVICE_REF_FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemRefObj#SRVC_REF_OBJ_IS_MAIN_OBJECT
 * SRVC_REF_OBJ_IS_MAIN_OBJECT}</li>
 * </ul>
 *
 */
public interface ServiceOrderTmplItemRefObjSelectable extends EntitySelectable<ServiceOrderTmplItemRefObj>
{

}
