/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText
 * ServiceOrderTmplItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTmplItemTextField
 * ServiceOrderTmplItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTmplItemTextLink
 * ServiceOrderTmplItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText#SERVICE_ORDER_TEMPLATE_ITEM
 * SERVICE_ORDER_TEMPLATE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceOrderTmplItemTextSelectable extends EntitySelectable<ServiceOrderTmplItemText>
{

}
