/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
 * ServiceOrderTmplRefObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTmplRefObjectField
 * ServiceOrderTmplRefObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTmplRefObjectLink
 * ServiceOrderTmplRefObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject#SERVICE_REFERENCE_EQUIPMENT
 * SERVICE_REFERENCE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject#SERVICE_REF_FUNCTIONAL_LOCATION
 * SERVICE_REF_FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject#SRVC_REF_OBJ_IS_MAIN_OBJECT
 * SRVC_REF_OBJ_IS_MAIN_OBJECT}</li>
 * </ul>
 *
 */
public interface ServiceOrderTmplRefObjectSelectable extends EntitySelectable<ServiceOrderTmplRefObject>
{

}
