/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus
 * SrvcOrdTmplItemUserStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.SrvcOrdTmplItemUserStatusField
 * SrvcOrdTmplItemUserStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.SrvcOrdTmplItemUserStatusLink
 * SrvcOrdTmplItemUserStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus#SERVICE_ORDER_TEMPLATE_ITEM
 * SERVICE_ORDER_TEMPLATE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemUserStatus#SRVC_ORD_TMPL_ITM_USER_STATUS
 * SRVC_ORD_TMPL_ITM_USER_STATUS}</li>
 * </ul>
 *
 */
public interface SrvcOrdTmplItemUserStatusSelectable extends EntitySelectable<SrvcOrdTmplItemUserStatus>
{

}
