/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress
 * SrvcOrdTmplPartnerAddress}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.SrvcOrdTmplPartnerAddressField
 * SrvcOrdTmplPartnerAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.SrvcOrdTmplPartnerAddressLink
 * SrvcOrdTmplPartnerAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#CUST_MGMT_PARTNER_FUNCTION
 * CUST_MGMT_PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#CUST_MGMT_BUSINESS_PARTNER
 * CUST_MGMT_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#ADDRESSEE_FULL_NAME
 * ADDRESSEE_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#DISTRICT_NAME
 * DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#FAX_AREA_CODE_SUBSCRIBER_NUMBER
 * FAX_AREA_CODE_SUBSCRIBER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#FAX_EXTENSION_NUMBER
 * FAX_EXTENSION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#FAX_NUMBER_COUNTRY
 * FAX_NUMBER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#MOBILE_NUMBER
 * MOBILE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#MOBILE_PHONE_COUNTRY
 * MOBILE_PHONE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#ORGANIZATION_NAME1
 * ORGANIZATION_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#ORGANIZATION_NAME2
 * ORGANIZATION_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#ORGANIZATION_NAME3
 * ORGANIZATION_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#ORGANIZATION_NAME4
 * ORGANIZATION_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PERSON_FAMILY_NAME
 * PERSON_FAMILY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PERSON_GIVEN_NAME
 * PERSON_GIVEN_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PHONE_EXTENSION_NUMBER
 * PHONE_EXTENSION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PHONE_NUMBER_COUNTRY
 * PHONE_NUMBER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PO_BOX
 * PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#STREET_PREFIX_NAME1
 * STREET_PREFIX_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#STREET_PREFIX_NAME2
 * STREET_PREFIX_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#STREET_SUFFIX_NAME1
 * STREET_SUFFIX_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#STREET_SUFFIX_NAME2
 * STREET_SUFFIX_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplPartnerAddress#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * </ul>
 *
 */
public interface SrvcOrdTmplPartnerAddressSelectable extends EntitySelectable<SrvcOrdTmplPartnerAddress>
{

}
