/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus
 * SrvcOrdTmplUserStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.SrvcOrdTmplUserStatusField
 * SrvcOrdTmplUserStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.SrvcOrdTmplUserStatusLink
 * SrvcOrdTmplUserStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus#SERVICE_ORDER_TEMPLATE
 * SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplUserStatus#SRVC_ORD_TMPL_USER_STATUS
 * SRVC_ORD_TMPL_USER_STATUS}</li>
 * </ul>
 *
 */
public interface SrvcOrdTmplUserStatusSelectable extends EntitySelectable<SrvcOrdTmplUserStatus>
{

}
