/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.selectable.ServiceQtanItemPriceElementSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
 * ServiceQtanItemPriceElement} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ServiceQtanItemPriceElementByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceQtanItemPriceElementByKeyFluentHelper, ServiceQtanItemPriceElement, ServiceQtanItemPriceElementSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceQtanItemPriceElement}
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceQtanItemPriceElement}
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public ServiceQtanItemPriceElementByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceQuotation", serviceQuotation);
        this.key.put("ServiceQuotationItem", serviceQuotationItem);
        this.key.put("PricingProcedureStep", pricingProcedureStep);
        this.key.put("PricingProcedureCounter", pricingProcedureCounter);
    }

    @Override
    @Nonnull
    protected Class<ServiceQtanItemPriceElement> getEntityClass()
    {
        return ServiceQtanItemPriceElement.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
