/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.field.ServiceQtanItemRefObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.link.ServiceQtanItemRefObjectOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.selectable.ServiceQtanItemRefObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Reference Object of Srvc Quotation Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceQtanItemRefObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceQtanItemRefObject extends VdmEntity<ServiceQtanItemRefObject>
{

    /**
     * Selector for all available fields of ServiceQtanItemRefObject.
     *
     */
    public final static ServiceQtanItemRefObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceQuotation" )
    @JsonProperty( "ServiceQuotation" )
    @Nullable
    @ODataField( odataName = "ServiceQuotation" )
    private String serviceQuotation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotation</b> field to query operations.
     *
     */
    public final static ServiceQtanItemRefObjectField<String> SERVICE_QUOTATION =
        new ServiceQtanItemRefObjectField<String>("ServiceQuotation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceQuotationItem" )
    @JsonProperty( "ServiceQuotationItem" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationItem" )
    private String serviceQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationItem</b> field to query operations.
     *
     */
    public final static ServiceQtanItemRefObjectField<String> SERVICE_QUOTATION_ITEM =
        new ServiceQtanItemRefObjectField<String>("ServiceQuotationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "ServiceReferenceEquipment" )
    @JsonProperty( "ServiceReferenceEquipment" )
    @Nullable
    @ODataField( odataName = "ServiceReferenceEquipment" )
    private String serviceReferenceEquipment;
    /**
     * Use with available fluent helpers to apply the <b>ServiceReferenceEquipment</b> field to query operations.
     *
     */
    public final static ServiceQtanItemRefObjectField<String> SERVICE_REFERENCE_EQUIPMENT =
        new ServiceQtanItemRefObjectField<String>("ServiceReferenceEquipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @Key
    @SerializedName( "ServiceRefFunctionalLocation" )
    @JsonProperty( "ServiceRefFunctionalLocation" )
    @Nullable
    @ODataField( odataName = "ServiceRefFunctionalLocation" )
    private String serviceRefFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceRefFunctionalLocation</b> field to query operations.
     *
     */
    public final static ServiceQtanItemRefObjectField<String> SERVICE_REF_FUNCTIONAL_LOCATION =
        new ServiceQtanItemRefObjectField<String>("ServiceRefFunctionalLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @return Main Reference Object
     */
    @SerializedName( "SrvcRefObjIsMainObject" )
    @JsonProperty( "SrvcRefObjIsMainObject" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcRefObjIsMainObject" )
    private Boolean srvcRefObjIsMainObject;
    /**
     * Use with available fluent helpers to apply the <b>SrvcRefObjIsMainObject</b> field to query operations.
     *
     */
    public final static ServiceQtanItemRefObjectField<Boolean> SRVC_REF_OBJ_IS_MAIN_OBJECT =
        new ServiceQtanItemRefObjectField<Boolean>("SrvcRefObjIsMainObject");
    /**
     * Navigation property <b>to_ServiceQuotation</b> for <b>ServiceQtanItemRefObject</b> to single
     * <b>ServiceQuotation</b>.
     *
     */
    @SerializedName( "to_ServiceQuotation" )
    @JsonProperty( "to_ServiceQuotation" )
    @ODataField( odataName = "to_ServiceQuotation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceQuotation toServiceQuotation;
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceQuotation</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceQtanItemRefObjectOneToOneLink<ServiceQuotation> TO_SERVICE_QUOTATION =
        new ServiceQtanItemRefObjectOneToOneLink<ServiceQuotation>("to_ServiceQuotation");

    @Nonnull
    @Override
    public Class<ServiceQtanItemRefObject> getType()
    {
        return ServiceQtanItemRefObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotation</b>
     * </p>
     *
     * @param serviceQuotation
     *            Transaction ID
     */
    public void setServiceQuotation( @Nullable final String serviceQuotation )
    {
        rememberChangedField("ServiceQuotation", this.serviceQuotation);
        this.serviceQuotation = serviceQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItem</b>
     * </p>
     *
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     */
    public void setServiceQuotationItem( @Nullable final String serviceQuotationItem )
    {
        rememberChangedField("ServiceQuotationItem", this.serviceQuotationItem);
        this.serviceQuotationItem = serviceQuotationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @param serviceReferenceEquipment
     *            Equipment Number
     */
    public void setServiceReferenceEquipment( @Nullable final String serviceReferenceEquipment )
    {
        rememberChangedField("ServiceReferenceEquipment", this.serviceReferenceEquipment);
        this.serviceReferenceEquipment = serviceReferenceEquipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     */
    public void setServiceRefFunctionalLocation( @Nullable final String serviceRefFunctionalLocation )
    {
        rememberChangedField("ServiceRefFunctionalLocation", this.serviceRefFunctionalLocation);
        this.serviceRefFunctionalLocation = serviceRefFunctionalLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @param srvcRefObjIsMainObject
     *            Main Reference Object
     */
    public void setSrvcRefObjIsMainObject( @Nullable final Boolean srvcRefObjIsMainObject )
    {
        rememberChangedField("SrvcRefObjIsMainObject", this.srvcRefObjIsMainObject);
        this.srvcRefObjIsMainObject = srvcRefObjIsMainObject;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceQtanItemRefObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceQuotation", getServiceQuotation());
        result.put("ServiceQuotationItem", getServiceQuotationItem());
        result.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        result.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceQuotation", getServiceQuotation());
        values.put("ServiceQuotationItem", getServiceQuotationItem());
        values.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        values.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        values.put("SrvcRefObjIsMainObject", getSrvcRefObjIsMainObject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceQuotation") ) {
                final Object value = values.remove("ServiceQuotation");
                if( (value == null) || (!value.equals(getServiceQuotation())) ) {
                    setServiceQuotation(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationItem") ) {
                final Object value = values.remove("ServiceQuotationItem");
                if( (value == null) || (!value.equals(getServiceQuotationItem())) ) {
                    setServiceQuotationItem(((String) value));
                }
            }
            if( values.containsKey("ServiceReferenceEquipment") ) {
                final Object value = values.remove("ServiceReferenceEquipment");
                if( (value == null) || (!value.equals(getServiceReferenceEquipment())) ) {
                    setServiceReferenceEquipment(((String) value));
                }
            }
            if( values.containsKey("ServiceRefFunctionalLocation") ) {
                final Object value = values.remove("ServiceRefFunctionalLocation");
                if( (value == null) || (!value.equals(getServiceRefFunctionalLocation())) ) {
                    setServiceRefFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("SrvcRefObjIsMainObject") ) {
                final Object value = values.remove("SrvcRefObjIsMainObject");
                if( (value == null) || (!value.equals(getSrvcRefObjIsMainObject())) ) {
                    setSrvcRefObjIsMainObject(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ServiceQuotation") ) {
                final Object value = (values).remove("to_ServiceQuotation");
                if( value instanceof Map ) {
                    if( toServiceQuotation == null ) {
                        toServiceQuotation = new ServiceQuotation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceQuotation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceQtanItemRefObjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceQtanItemRefObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceQtanItemRefObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceQtanItemRefObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toServiceQuotation != null ) {
            (values).put("to_ServiceQuotation", toServiceQuotation);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceQuotation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceQuotation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceQuotation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceQuotation fetchServiceQuotation()
    {
        return fetchFieldAsSingle("to_ServiceQuotation", ServiceQuotation.class);
    }

    /**
     * Retrieval of associated <b>ServiceQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceQuotation</b>.
     * <p>
     * If the navigation property <b>to_ServiceQuotation</b> of a queried <b>ServiceQtanItemRefObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQuotation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceQuotation getServiceQuotationOrFetch()
    {
        if( toServiceQuotation == null ) {
            toServiceQuotation = fetchServiceQuotation();
        }
        return toServiceQuotation;
    }

    /**
     * Retrieval of associated <b>ServiceQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceQuotation</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQtanItemRefObject</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceQuotation</b> is already loaded, the result will
     *         contain the <b>ServiceQuotation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceQuotation> getServiceQuotationIfPresent()
    {
        return Option.of(toServiceQuotation);
    }

    /**
     * Overwrites the associated <b>ServiceQuotation</b> entity for the loaded navigation property
     * <b>to_ServiceQuotation</b>.
     *
     * @param value
     *            New <b>ServiceQuotation</b> entity.
     */
    public void setServiceQuotation( final ServiceQuotation value )
    {
        toServiceQuotation = value;
    }

    /**
     * Helper class to allow for fluent creation of ServiceQtanItemRefObject instances.
     *
     */
    public final static class ServiceQtanItemRefObjectBuilder
    {

        private ServiceQuotation toServiceQuotation;
        private String serviceQuotation = null;

        private ServiceQtanItemRefObject.ServiceQtanItemRefObjectBuilder toServiceQuotation(
            final ServiceQuotation value )
        {
            toServiceQuotation = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceQuotation</b> for <b>ServiceQtanItemRefObject</b> to single
         * <b>ServiceQuotation</b>.
         *
         * @param value
         *            The ServiceQuotation to build this ServiceQtanItemRefObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQtanItemRefObject.ServiceQtanItemRefObjectBuilder serviceQuotation( final ServiceQuotation value )
        {
            return toServiceQuotation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceQuotation</b>
         * </p>
         *
         * @param value
         *            The serviceQuotation to build this ServiceQtanItemRefObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQtanItemRefObject.ServiceQtanItemRefObjectBuilder serviceQuotation( final String value )
        {
            serviceQuotation = value;
            return this;
        }

    }

}
