/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.field.ServiceQuotationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.link.ServiceQuotationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.selectable.ServiceQuotationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Quotation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceQuotationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceQuotation extends VdmEntity<ServiceQuotation>
{

    /**
     * Selector for all available fields of ServiceQuotation.
     *
     */
    public final static ServiceQuotationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceQuotation" )
    @JsonProperty( "ServiceQuotation" )
    @Nullable
    @ODataField( odataName = "ServiceQuotation" )
    private String serviceQuotation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotation</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QUOTATION =
        new ServiceQuotationField<String>("ServiceQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceQuotationType" )
    @JsonProperty( "ServiceQuotationType" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationType" )
    private String serviceQuotationType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationType</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QUOTATION_TYPE =
        new ServiceQuotationField<String>("ServiceQuotationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceQuotationUUID" )
    @JsonProperty( "ServiceQuotationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationUUID" )
    private UUID serviceQuotationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationUUID</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<UUID> SERVICE_QUOTATION_UUID =
        new ServiceQuotationField<UUID>("ServiceQuotationUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationDescription</b>
     * </p>
     *
     * @return Transaction Description
     */
    @SerializedName( "ServiceQuotationDescription" )
    @JsonProperty( "ServiceQuotationDescription" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationDescription" )
    private String serviceQuotationDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationDescription</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QUOTATION_DESCRIPTION =
        new ServiceQuotationField<String>("ServiceQuotationDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key of Description
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> LANGUAGE = new ServiceQuotationField<String>("Language");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @return Service Request Start Date
     */
    @SerializedName( "RequestedServiceStartDateTime" )
    @JsonProperty( "RequestedServiceStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<ZonedDateTime> REQUESTED_SERVICE_START_DATE_TIME =
        new ServiceQuotationField<ZonedDateTime>("RequestedServiceStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @return Service Request Due Date
     */
    @SerializedName( "RequestedServiceEndDateTime" )
    @JsonProperty( "RequestedServiceEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<ZonedDateTime> REQUESTED_SERVICE_END_DATE_TIME =
        new ServiceQuotationField<ZonedDateTime>("RequestedServiceEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQtanValidityStartDateTime</b>
     * </p>
     *
     * @return Contract Start date
     */
    @SerializedName( "SrvcQtanValidityStartDateTime" )
    @JsonProperty( "SrvcQtanValidityStartDateTime" )
    @Nullable
    @ODataField( odataName = "SrvcQtanValidityStartDateTime" )
    private BigDecimal srvcQtanValidityStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcQtanValidityStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<BigDecimal> SRVC_QTAN_VALIDITY_START_DATE_TIME =
        new ServiceQuotationField<BigDecimal>("SrvcQtanValidityStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQtanValidityEndDateTime</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "SrvcQtanValidityEndDateTime" )
    @JsonProperty( "SrvcQtanValidityEndDateTime" )
    @Nullable
    @ODataField( odataName = "SrvcQtanValidityEndDateTime" )
    private BigDecimal srvcQtanValidityEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcQtanValidityEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<BigDecimal> SRVC_QTAN_VALIDITY_END_DATE_TIME =
        new ServiceQuotationField<BigDecimal>("SrvcQtanValidityEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ServiceQtanExtReference" )
    @JsonProperty( "ServiceQtanExtReference" )
    @Nullable
    @ODataField( odataName = "ServiceQtanExtReference" )
    private String serviceQtanExtReference;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQtanExtReference</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QTAN_EXT_REFERENCE =
        new ServiceQuotationField<String>("ServiceQtanExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ServiceQuotationIsReleased" )
    @JsonProperty( "ServiceQuotationIsReleased" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationIsReleased" )
    private String serviceQuotationIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationIsReleased</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QUOTATION_IS_RELEASED =
        new ServiceQuotationField<String>("ServiceQuotationIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationIsAccepted</b>
     * </p>
     *
     * @return The serviceQuotationIsAccepted contained in this entity.
     */
    @SerializedName( "ServiceQuotationIsAccepted" )
    @JsonProperty( "ServiceQuotationIsAccepted" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationIsAccepted" )
    private String serviceQuotationIsAccepted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationIsAccepted</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QUOTATION_IS_ACCEPTED =
        new ServiceQuotationField<String>("ServiceQuotationIsAccepted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "ServiceQuotationIsRejected" )
    @JsonProperty( "ServiceQuotationIsRejected" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationIsRejected" )
    private String serviceQuotationIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationIsRejected</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QUOTATION_IS_REJECTED =
        new ServiceQuotationField<String>("ServiceQuotationIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQuotationRejectionReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "SrvcQuotationRejectionReason" )
    @JsonProperty( "SrvcQuotationRejectionReason" )
    @Nullable
    @ODataField( odataName = "SrvcQuotationRejectionReason" )
    private String srvcQuotationRejectionReason;
    /**
     * Use with available fluent helpers to apply the <b>SrvcQuotationRejectionReason</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SRVC_QUOTATION_REJECTION_REASON =
        new ServiceQuotationField<String>("SrvcQuotationRejectionReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SALES_ORGANIZATION =
        new ServiceQuotationField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> DISTRIBUTION_CHANNEL =
        new ServiceQuotationField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> DIVISION = new ServiceQuotationField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SALES_OFFICE = new ServiceQuotationField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SALES_GROUP = new ServiceQuotationField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SOLD_TO_PARTY = new ServiceQuotationField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SHIP_TO_PARTY = new ServiceQuotationField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> CONTACT_PERSON =
        new ServiceQuotationField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanSuccessorOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceQtanSuccessorOrder" )
    @JsonProperty( "ServiceQtanSuccessorOrder" )
    @Nullable
    @ODataField( odataName = "ServiceQtanSuccessorOrder" )
    private String serviceQtanSuccessorOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQtanSuccessorOrder</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> SERVICE_QTAN_SUCCESSOR_ORDER =
        new ServiceQuotationField<String>("ServiceQtanSuccessorOrder");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @return Service Team (Responsibility Management)
     */
    @SerializedName( "RespyMgmtServiceTeam" )
    @JsonProperty( "RespyMgmtServiceTeam" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeam" )
    private String respyMgmtServiceTeam;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeam</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> RESPY_MGMT_SERVICE_TEAM =
        new ServiceQuotationField<String>("RespyMgmtServiceTeam");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "RespyMgmtServiceTeamName" )
    @JsonProperty( "RespyMgmtServiceTeamName" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeamName" )
    private String respyMgmtServiceTeamName;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeamName</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> RESPY_MGMT_SERVICE_TEAM_NAME =
        new ServiceQuotationField<String>("RespyMgmtServiceTeamName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @return Global Team ID in Responsibility Mgmt.
     */
    @SerializedName( "RespyMgmtGlobalTeamID" )
    @JsonProperty( "RespyMgmtGlobalTeamID" )
    @Nullable
    @ODataField( odataName = "RespyMgmtGlobalTeamID" )
    private String respyMgmtGlobalTeamID;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtGlobalTeamID</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> RESPY_MGMT_GLOBAL_TEAM_ID =
        new ServiceQuotationField<String>("RespyMgmtGlobalTeamID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> PAYMENT_TERMS = new ServiceQuotationField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> TRANSACTION_CURRENCY =
        new ServiceQuotationField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocGrossAmount</b>
     * </p>
     *
     * @return Total Gross Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocGrossAmount" )
    @JsonProperty( "ServiceDocGrossAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocGrossAmount" )
    private BigDecimal serviceDocGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocGrossAmount</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<BigDecimal> SERVICE_DOC_GROSS_AMOUNT =
        new ServiceQuotationField<BigDecimal>("ServiceDocGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @return Total Net Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocNetAmount" )
    @JsonProperty( "ServiceDocNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocNetAmount" )
    private BigDecimal serviceDocNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocNetAmount</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<BigDecimal> SERVICE_DOC_NET_AMOUNT =
        new ServiceQuotationField<BigDecimal>("ServiceDocNetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocTaxAmount</b>
     * </p>
     *
     * @return Total Tax Amount in Document Currency
     */
    @SerializedName( "ServiceDocTaxAmount" )
    @JsonProperty( "ServiceDocTaxAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocTaxAmount" )
    private BigDecimal serviceDocTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocTaxAmount</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<BigDecimal> SERVICE_DOC_TAX_AMOUNT =
        new ServiceQuotationField<BigDecimal>("ServiceDocTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceInHouseRepair</b>
     * </p>
     *
     * @return Reference In-House Repair
     */
    @SerializedName( "ReferenceInHouseRepair" )
    @JsonProperty( "ReferenceInHouseRepair" )
    @Nullable
    @ODataField( odataName = "ReferenceInHouseRepair" )
    private String referenceInHouseRepair;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceInHouseRepair</b> field to query operations.
     *
     */
    public final static ServiceQuotationField<String> REFERENCE_IN_HOUSE_REPAIR =
        new ServiceQuotationField<String>("ReferenceInHouseRepair");
    /**
     * Navigation property <b>to_Item</b> for <b>ServiceQuotation</b> to multiple <b>ServiceQuotationItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQuotationItem> toItem;
    /**
     * Navigation property <b>to_PersonResponsible</b> for <b>ServiceQuotation</b> to multiple
     * <b>ServiceQtanPersonResp</b>.
     *
     */
    @SerializedName( "to_PersonResponsible" )
    @JsonProperty( "to_PersonResponsible" )
    @ODataField( odataName = "to_PersonResponsible" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQtanPersonResp> toPersonResponsible;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceQuotation</b> to multiple
     * <b>ServiceQtanPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQtanPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceQuotation</b> to multiple
     * <b>ServiceQtanRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQtanRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceQuotation</b> to multiple <b>ServiceQuotationText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQuotationText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationLink<ServiceQuotationItem> TO_ITEM =
        new ServiceQuotationLink<ServiceQuotationItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_PersonResponsible</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceQuotationLink<ServiceQtanPersonResp> TO_PERSON_RESPONSIBLE =
        new ServiceQuotationLink<ServiceQtanPersonResp>("to_PersonResponsible");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationLink<ServiceQtanPriceElement> TO_PRICING_ELEMENT =
        new ServiceQuotationLink<ServiceQtanPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationLink<ServiceQtanRefObject> TO_REFERENCE_OBJECT =
        new ServiceQuotationLink<ServiceQtanRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationLink<ServiceQuotationText> TO_TEXT =
        new ServiceQuotationLink<ServiceQuotationText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceQuotation> getType()
    {
        return ServiceQuotation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotation</b>
     * </p>
     *
     * @param serviceQuotation
     *            Transaction ID
     */
    public void setServiceQuotation( @Nullable final String serviceQuotation )
    {
        rememberChangedField("ServiceQuotation", this.serviceQuotation);
        this.serviceQuotation = serviceQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationType</b>
     * </p>
     *
     * @param serviceQuotationType
     *            Business Transaction Type
     */
    public void setServiceQuotationType( @Nullable final String serviceQuotationType )
    {
        rememberChangedField("ServiceQuotationType", this.serviceQuotationType);
        this.serviceQuotationType = serviceQuotationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationUUID</b>
     * </p>
     *
     * @param serviceQuotationUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceQuotationUUID( @Nullable final UUID serviceQuotationUUID )
    {
        rememberChangedField("ServiceQuotationUUID", this.serviceQuotationUUID);
        this.serviceQuotationUUID = serviceQuotationUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationDescription</b>
     * </p>
     *
     * @param serviceQuotationDescription
     *            Transaction Description
     */
    public void setServiceQuotationDescription( @Nullable final String serviceQuotationDescription )
    {
        rememberChangedField("ServiceQuotationDescription", this.serviceQuotationDescription);
        this.serviceQuotationDescription = serviceQuotationDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key of Description
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @param requestedServiceStartDateTime
     *            Service Request Start Date
     */
    public void setRequestedServiceStartDateTime( @Nullable final ZonedDateTime requestedServiceStartDateTime )
    {
        rememberChangedField("RequestedServiceStartDateTime", this.requestedServiceStartDateTime);
        this.requestedServiceStartDateTime = requestedServiceStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @param requestedServiceEndDateTime
     *            Service Request Due Date
     */
    public void setRequestedServiceEndDateTime( @Nullable final ZonedDateTime requestedServiceEndDateTime )
    {
        rememberChangedField("RequestedServiceEndDateTime", this.requestedServiceEndDateTime);
        this.requestedServiceEndDateTime = requestedServiceEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQtanValidityStartDateTime</b>
     * </p>
     *
     * @param srvcQtanValidityStartDateTime
     *            Contract Start date
     */
    public void setSrvcQtanValidityStartDateTime( @Nullable final BigDecimal srvcQtanValidityStartDateTime )
    {
        rememberChangedField("SrvcQtanValidityStartDateTime", this.srvcQtanValidityStartDateTime);
        this.srvcQtanValidityStartDateTime = srvcQtanValidityStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQtanValidityEndDateTime</b>
     * </p>
     *
     * @param srvcQtanValidityEndDateTime
     *            Contract End Date
     */
    public void setSrvcQtanValidityEndDateTime( @Nullable final BigDecimal srvcQtanValidityEndDateTime )
    {
        rememberChangedField("SrvcQtanValidityEndDateTime", this.srvcQtanValidityEndDateTime);
        this.srvcQtanValidityEndDateTime = srvcQtanValidityEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanExtReference</b>
     * </p>
     *
     * @param serviceQtanExtReference
     *            External Reference Number
     */
    public void setServiceQtanExtReference( @Nullable final String serviceQtanExtReference )
    {
        rememberChangedField("ServiceQtanExtReference", this.serviceQtanExtReference);
        this.serviceQtanExtReference = serviceQtanExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationIsReleased</b>
     * </p>
     *
     * @param serviceQuotationIsReleased
     *            Release Status
     */
    public void setServiceQuotationIsReleased( @Nullable final String serviceQuotationIsReleased )
    {
        rememberChangedField("ServiceQuotationIsReleased", this.serviceQuotationIsReleased);
        this.serviceQuotationIsReleased = serviceQuotationIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationIsAccepted</b>
     * </p>
     *
     * @param serviceQuotationIsAccepted
     *            The serviceQuotationIsAccepted to set.
     */
    public void setServiceQuotationIsAccepted( @Nullable final String serviceQuotationIsAccepted )
    {
        rememberChangedField("ServiceQuotationIsAccepted", this.serviceQuotationIsAccepted);
        this.serviceQuotationIsAccepted = serviceQuotationIsAccepted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationIsRejected</b>
     * </p>
     *
     * @param serviceQuotationIsRejected
     *            Cancellation Status
     */
    public void setServiceQuotationIsRejected( @Nullable final String serviceQuotationIsRejected )
    {
        rememberChangedField("ServiceQuotationIsRejected", this.serviceQuotationIsRejected);
        this.serviceQuotationIsRejected = serviceQuotationIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQuotationRejectionReason</b>
     * </p>
     *
     * @param srvcQuotationRejectionReason
     *            Cancellation Reason Code
     */
    public void setSrvcQuotationRejectionReason( @Nullable final String srvcQuotationRejectionReason )
    {
        rememberChangedField("SrvcQuotationRejectionReason", this.srvcQuotationRejectionReason);
        this.srvcQuotationRejectionReason = srvcQuotationRejectionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanSuccessorOrder</b>
     * </p>
     *
     * @param serviceQtanSuccessorOrder
     *            Transaction ID
     */
    public void setServiceQtanSuccessorOrder( @Nullable final String serviceQtanSuccessorOrder )
    {
        rememberChangedField("ServiceQtanSuccessorOrder", this.serviceQtanSuccessorOrder);
        this.serviceQtanSuccessorOrder = serviceQtanSuccessorOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @param respyMgmtServiceTeam
     *            Service Team (Responsibility Management)
     */
    public void setRespyMgmtServiceTeam( @Nullable final String respyMgmtServiceTeam )
    {
        rememberChangedField("RespyMgmtServiceTeam", this.respyMgmtServiceTeam);
        this.respyMgmtServiceTeam = respyMgmtServiceTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @param respyMgmtServiceTeamName
     *            Name
     */
    public void setRespyMgmtServiceTeamName( @Nullable final String respyMgmtServiceTeamName )
    {
        rememberChangedField("RespyMgmtServiceTeamName", this.respyMgmtServiceTeamName);
        this.respyMgmtServiceTeamName = respyMgmtServiceTeamName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocGrossAmount</b>
     * </p>
     *
     * @param serviceDocGrossAmount
     *            Total Gross Value of Document in Document Currency
     */
    public void setServiceDocGrossAmount( @Nullable final BigDecimal serviceDocGrossAmount )
    {
        rememberChangedField("ServiceDocGrossAmount", this.serviceDocGrossAmount);
        this.serviceDocGrossAmount = serviceDocGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @param serviceDocNetAmount
     *            Total Net Value of Document in Document Currency
     */
    public void setServiceDocNetAmount( @Nullable final BigDecimal serviceDocNetAmount )
    {
        rememberChangedField("ServiceDocNetAmount", this.serviceDocNetAmount);
        this.serviceDocNetAmount = serviceDocNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocTaxAmount</b>
     * </p>
     *
     * @param serviceDocTaxAmount
     *            Total Tax Amount in Document Currency
     */
    public void setServiceDocTaxAmount( @Nullable final BigDecimal serviceDocTaxAmount )
    {
        rememberChangedField("ServiceDocTaxAmount", this.serviceDocTaxAmount);
        this.serviceDocTaxAmount = serviceDocTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceInHouseRepair</b>
     * </p>
     *
     * @param referenceInHouseRepair
     *            Reference In-House Repair
     */
    public void setReferenceInHouseRepair( @Nullable final String referenceInHouseRepair )
    {
        rememberChangedField("ReferenceInHouseRepair", this.referenceInHouseRepair);
        this.referenceInHouseRepair = referenceInHouseRepair;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceQuotation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceQuotation", getServiceQuotation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceQuotation", getServiceQuotation());
        values.put("ServiceQuotationType", getServiceQuotationType());
        values.put("ServiceQuotationUUID", getServiceQuotationUUID());
        values.put("ServiceQuotationDescription", getServiceQuotationDescription());
        values.put("Language", getLanguage());
        values.put("RequestedServiceStartDateTime", getRequestedServiceStartDateTime());
        values.put("RequestedServiceEndDateTime", getRequestedServiceEndDateTime());
        values.put("SrvcQtanValidityStartDateTime", getSrvcQtanValidityStartDateTime());
        values.put("SrvcQtanValidityEndDateTime", getSrvcQtanValidityEndDateTime());
        values.put("ServiceQtanExtReference", getServiceQtanExtReference());
        values.put("ServiceQuotationIsReleased", getServiceQuotationIsReleased());
        values.put("ServiceQuotationIsAccepted", getServiceQuotationIsAccepted());
        values.put("ServiceQuotationIsRejected", getServiceQuotationIsRejected());
        values.put("SrvcQuotationRejectionReason", getSrvcQuotationRejectionReason());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("ContactPerson", getContactPerson());
        values.put("ServiceQtanSuccessorOrder", getServiceQtanSuccessorOrder());
        values.put("RespyMgmtServiceTeam", getRespyMgmtServiceTeam());
        values.put("RespyMgmtServiceTeamName", getRespyMgmtServiceTeamName());
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ServiceDocGrossAmount", getServiceDocGrossAmount());
        values.put("ServiceDocNetAmount", getServiceDocNetAmount());
        values.put("ServiceDocTaxAmount", getServiceDocTaxAmount());
        values.put("ReferenceInHouseRepair", getReferenceInHouseRepair());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceQuotation") ) {
                final Object value = values.remove("ServiceQuotation");
                if( (value == null) || (!value.equals(getServiceQuotation())) ) {
                    setServiceQuotation(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationType") ) {
                final Object value = values.remove("ServiceQuotationType");
                if( (value == null) || (!value.equals(getServiceQuotationType())) ) {
                    setServiceQuotationType(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationUUID") ) {
                final Object value = values.remove("ServiceQuotationUUID");
                if( (value == null) || (!value.equals(getServiceQuotationUUID())) ) {
                    setServiceQuotationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceQuotationDescription") ) {
                final Object value = values.remove("ServiceQuotationDescription");
                if( (value == null) || (!value.equals(getServiceQuotationDescription())) ) {
                    setServiceQuotationDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("RequestedServiceStartDateTime") ) {
                final Object value = values.remove("RequestedServiceStartDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceStartDateTime())) ) {
                    setRequestedServiceStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RequestedServiceEndDateTime") ) {
                final Object value = values.remove("RequestedServiceEndDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceEndDateTime())) ) {
                    setRequestedServiceEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcQtanValidityStartDateTime") ) {
                final Object value = values.remove("SrvcQtanValidityStartDateTime");
                if( (value == null) || (!value.equals(getSrvcQtanValidityStartDateTime())) ) {
                    setSrvcQtanValidityStartDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcQtanValidityEndDateTime") ) {
                final Object value = values.remove("SrvcQtanValidityEndDateTime");
                if( (value == null) || (!value.equals(getSrvcQtanValidityEndDateTime())) ) {
                    setSrvcQtanValidityEndDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceQtanExtReference") ) {
                final Object value = values.remove("ServiceQtanExtReference");
                if( (value == null) || (!value.equals(getServiceQtanExtReference())) ) {
                    setServiceQtanExtReference(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationIsReleased") ) {
                final Object value = values.remove("ServiceQuotationIsReleased");
                if( (value == null) || (!value.equals(getServiceQuotationIsReleased())) ) {
                    setServiceQuotationIsReleased(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationIsAccepted") ) {
                final Object value = values.remove("ServiceQuotationIsAccepted");
                if( (value == null) || (!value.equals(getServiceQuotationIsAccepted())) ) {
                    setServiceQuotationIsAccepted(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationIsRejected") ) {
                final Object value = values.remove("ServiceQuotationIsRejected");
                if( (value == null) || (!value.equals(getServiceQuotationIsRejected())) ) {
                    setServiceQuotationIsRejected(((String) value));
                }
            }
            if( values.containsKey("SrvcQuotationRejectionReason") ) {
                final Object value = values.remove("SrvcQuotationRejectionReason");
                if( (value == null) || (!value.equals(getSrvcQuotationRejectionReason())) ) {
                    setSrvcQuotationRejectionReason(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("ServiceQtanSuccessorOrder") ) {
                final Object value = values.remove("ServiceQtanSuccessorOrder");
                if( (value == null) || (!value.equals(getServiceQtanSuccessorOrder())) ) {
                    setServiceQtanSuccessorOrder(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeam") ) {
                final Object value = values.remove("RespyMgmtServiceTeam");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeam())) ) {
                    setRespyMgmtServiceTeam(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeamName") ) {
                final Object value = values.remove("RespyMgmtServiceTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeamName())) ) {
                    setRespyMgmtServiceTeamName(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ServiceDocGrossAmount") ) {
                final Object value = values.remove("ServiceDocGrossAmount");
                if( (value == null) || (!value.equals(getServiceDocGrossAmount())) ) {
                    setServiceDocGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocNetAmount") ) {
                final Object value = values.remove("ServiceDocNetAmount");
                if( (value == null) || (!value.equals(getServiceDocNetAmount())) ) {
                    setServiceDocNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocTaxAmount") ) {
                final Object value = values.remove("ServiceDocTaxAmount");
                if( (value == null) || (!value.equals(getServiceDocTaxAmount())) ) {
                    setServiceDocTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReferenceInHouseRepair") ) {
                final Object value = values.remove("ReferenceInHouseRepair");
                if( (value == null) || (!value.equals(getReferenceInHouseRepair())) ) {
                    setReferenceInHouseRepair(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQuotationItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new ServiceQuotationItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PersonResponsible") ) {
                final Object value = (values).remove("to_PersonResponsible");
                if( value instanceof Iterable ) {
                    if( toPersonResponsible == null ) {
                        toPersonResponsible = Lists.newArrayList();
                    } else {
                        toPersonResponsible = Lists.newArrayList(toPersonResponsible);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQtanPersonResp entity;
                        if( toPersonResponsible.size() > i ) {
                            entity = toPersonResponsible.get(i);
                        } else {
                            entity = new ServiceQtanPersonResp();
                            toPersonResponsible.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQtanPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceQtanPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQtanRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceQtanRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQuotationText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceQuotationText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceQuotationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceQuotationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceQuotationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceQuotationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPersonResponsible != null ) {
            (values).put("to_PersonResponsible", toPersonResponsible);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceQuotationItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQuotationItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQuotationItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", ServiceQuotationItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceQuotationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQuotationItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQuotationItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>ServiceQuotationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>ServiceQuotationItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ServiceQuotationItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>ServiceQuotationItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQuotationItem</b> entities.
     */
    public void setItem( @Nonnull final List<ServiceQuotationItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQuotationItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQuotationItem</b> entities.
     */
    public void addItem( ServiceQuotationItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceQtanPersonResp</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PersonResponsible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQtanPersonResp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanPersonResp> fetchPersonResponsible()
    {
        return fetchFieldAsList("to_PersonResponsible", ServiceQtanPersonResp.class);
    }

    /**
     * Retrieval of associated <b>ServiceQtanPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceQuotation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQtanPersonResp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanPersonResp> getPersonResponsibleOrFetch()
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = fetchPersonResponsible();
        }
        return toPersonResponsible;
    }

    /**
     * Retrieval of associated <b>ServiceQtanPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PersonResponsible</b> is already loaded, the result will
     *         contain the <b>ServiceQtanPersonResp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceQtanPersonResp>> getPersonResponsibleIfPresent()
    {
        return Option.of(toPersonResponsible);
    }

    /**
     * Overwrites the list of associated <b>ServiceQtanPersonResp</b> entities for the loaded navigation property
     * <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceQuotation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQtanPersonResp</b> entities.
     */
    public void setPersonResponsible( @Nonnull final List<ServiceQtanPersonResp> value )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.clear();
        toPersonResponsible.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQtanPersonResp</b> entities. This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceQuotation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQtanPersonResp</b> entities.
     */
    public void addPersonResponsible( ServiceQtanPersonResp... entity )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceQtanPriceElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQtanPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceQtanPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceQtanPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQtanPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceQtanPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceQtanPriceElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceQtanPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceQtanPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQtanPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceQtanPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQtanPriceElement</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQtanPriceElement</b> entities.
     */
    public void addPricingElement( ServiceQtanPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceQtanRefObject</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQtanRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceQtanRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceQtanRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQtanRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceQtanRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceQtanRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceQtanRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceQtanRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQtanRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceQtanRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQtanRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQtanRefObject</b> entities.
     */
    public void addReferenceObject( ServiceQtanRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceQuotationText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQuotationText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQuotationText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceQuotationText.class);
    }

    /**
     * Retrieval of associated <b>ServiceQuotationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQuotationText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQuotationText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceQuotationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceQuotationText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ServiceQuotationText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceQuotationText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQuotationText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceQuotationText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQuotationText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceQuotation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQuotationText</b> entities.
     */
    public void addText( ServiceQuotationText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceQuotation instances.
     *
     */
    public final static class ServiceQuotationBuilder
    {

        private List<ServiceQuotationItem> toItem = Lists.newArrayList();
        private List<ServiceQtanPersonResp> toPersonResponsible = Lists.newArrayList();
        private List<ServiceQtanPriceElement> toPricingElement = Lists.newArrayList();
        private List<ServiceQtanRefObject> toReferenceObject = Lists.newArrayList();
        private List<ServiceQuotationText> toText = Lists.newArrayList();

        private ServiceQuotation.ServiceQuotationBuilder toItem( final List<ServiceQuotationItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>ServiceQuotation</b> to multiple <b>ServiceQuotationItem</b>.
         *
         * @param value
         *            The ServiceQuotationItems to build this ServiceQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotation.ServiceQuotationBuilder item( ServiceQuotationItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private ServiceQuotation.ServiceQuotationBuilder toPersonResponsible( final List<ServiceQtanPersonResp> value )
        {
            toPersonResponsible.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PersonResponsible</b> for <b>ServiceQuotation</b> to multiple
         * <b>ServiceQtanPersonResp</b>.
         *
         * @param value
         *            The ServiceQtanPersonResps to build this ServiceQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotation.ServiceQuotationBuilder personResponsible( ServiceQtanPersonResp... value )
        {
            return toPersonResponsible(Lists.newArrayList(value));
        }

        private ServiceQuotation.ServiceQuotationBuilder toPricingElement( final List<ServiceQtanPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceQuotation</b> to multiple
         * <b>ServiceQtanPriceElement</b>.
         *
         * @param value
         *            The ServiceQtanPriceElements to build this ServiceQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotation.ServiceQuotationBuilder pricingElement( ServiceQtanPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceQuotation.ServiceQuotationBuilder toReferenceObject( final List<ServiceQtanRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceQuotation</b> to multiple
         * <b>ServiceQtanRefObject</b>.
         *
         * @param value
         *            The ServiceQtanRefObjects to build this ServiceQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotation.ServiceQuotationBuilder referenceObject( ServiceQtanRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceQuotation.ServiceQuotationBuilder toText( final List<ServiceQuotationText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceQuotation</b> to multiple <b>ServiceQuotationText</b>.
         *
         * @param value
         *            The ServiceQuotationTexts to build this ServiceQuotation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotation.ServiceQuotationBuilder text( ServiceQuotationText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
