/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ServiceQuotationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService ServiceQuotationService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultServiceQuotationServiceBatch
    extends
    BatchFluentHelperBasic<ServiceQuotationServiceBatch, ServiceQuotationServiceBatchChangeSet>
    implements
    ServiceQuotationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultServiceQuotationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceQuotationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultServiceQuotationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceQuotationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultServiceQuotationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultServiceQuotationServiceBatchChangeSet(this, service);
    }

}
