/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText;

/**
 * Implementation of the {@link ServiceQuotationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService ServiceQuotationService}.
 *
 */
public class DefaultServiceQuotationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ServiceQuotationServiceBatch, ServiceQuotationServiceBatchChangeSet>
    implements
    ServiceQuotationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService service;

    @SuppressWarnings( "deprecation" )
    DefaultServiceQuotationServiceBatchChangeSet(
        @Nonnull final DefaultServiceQuotationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultServiceQuotationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return addRequestCreate(service::createServiceQtanItemPriceElement, serviceQtanItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return addRequestUpdate(service::updateServiceQtanItemPriceElement, serviceQtanItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return addRequestDelete(service::deleteServiceQtanItemPriceElement, serviceQtanItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQtanItemRefObject(
        @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject )
    {
        return addRequestCreate(service::createServiceQtanItemRefObject, serviceQtanItemRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQtanItemRefObject(
        @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject )
    {
        return addRequestDelete(service::deleteServiceQtanItemRefObject, serviceQtanItemRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return addRequestCreate(service::createServiceQtanPersonResp, serviceQtanPersonResp);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return addRequestUpdate(service::updateServiceQtanPersonResp, serviceQtanPersonResp);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return addRequestDelete(service::deleteServiceQtanPersonResp, serviceQtanPersonResp);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return addRequestCreate(service::createServiceQtanPriceElement, serviceQtanPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return addRequestUpdate(service::updateServiceQtanPriceElement, serviceQtanPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return addRequestDelete(service::deleteServiceQtanPriceElement, serviceQtanPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQtanRefObject(
        @Nonnull final ServiceQtanRefObject serviceQtanRefObject )
    {
        return addRequestCreate(service::createServiceQtanRefObject, serviceQtanRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQtanRefObject(
        @Nonnull final ServiceQtanRefObject serviceQtanRefObject )
    {
        return addRequestDelete(service::deleteServiceQtanRefObject, serviceQtanRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQuotation(
        @Nonnull final ServiceQuotation serviceQuotation )
    {
        return addRequestCreate(service::createServiceQuotation, serviceQuotation);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQuotation(
        @Nonnull final ServiceQuotation serviceQuotation )
    {
        return addRequestUpdate(service::updateServiceQuotation, serviceQuotation);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return addRequestCreate(service::createServiceQuotationItem, serviceQuotationItem);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return addRequestUpdate(service::updateServiceQuotationItem, serviceQuotationItem);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return addRequestDelete(service::deleteServiceQuotationItem, serviceQuotationItem);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return addRequestCreate(service::createServiceQuotationItemText, serviceQuotationItemText);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return addRequestUpdate(service::updateServiceQuotationItemText, serviceQuotationItemText);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return addRequestDelete(service::deleteServiceQuotationItemText, serviceQuotationItemText);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet createServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return addRequestCreate(service::createServiceQuotationText, serviceQuotationText);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet updateServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return addRequestUpdate(service::updateServiceQuotationText, serviceQuotationText);
    }

    @Nonnull
    @Override
    public ServiceQuotationServiceBatchChangeSet deleteServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return addRequestDelete(service::deleteServiceQuotationText, serviceQuotationText);
    }

}
