/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationService ServiceQuotationService}.
 *
 */
public interface ServiceQuotationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ServiceQuotationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ServiceQuotationServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        updateServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity in the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *            ServiceQtanItemRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQtanItemRefObject( @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity in the S/4HANA system.
     *
     * @param serviceQtanItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *            ServiceQtanItemRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQtanItemRefObject( @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        updateServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity in the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        updateServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity in the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     * ServiceQtanRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *            ServiceQtanRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQtanRefObject( @Nonnull final ServiceQtanRefObject serviceQtanRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     * ServiceQtanRefObject} entity in the S/4HANA system.
     *
     * @param serviceQtanRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *            ServiceQtanRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQtanRefObject( @Nonnull final ServiceQtanRefObject serviceQtanRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     * ServiceQuotation} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *            ServiceQuotation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet createServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     * ServiceQuotation} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *            ServiceQuotation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet updateServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        updateServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity in the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        updateServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity in the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        createServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        updateServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity in the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationServiceBatchChangeSet
        deleteServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

}
