/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
 * ServiceQtanItemPriceElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.field.ServiceQtanItemPriceElementField
 * ServiceQtanItemPriceElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.link.ServiceQtanItemPriceElementLink
 * ServiceQtanItemPriceElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#SERVICE_QUOTATION
 * SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#SERVICE_QUOTATION_ITEM
 * SERVICE_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#SERVICE_DOCUMENT_IS_QUOTATION
 * SERVICE_DOCUMENT_IS_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement#TO_SERVICE_QUOTATION
 * TO_SERVICE_QUOTATION}</li>
 * </ul>
 *
 */
public interface ServiceQtanItemPriceElementSelectable extends EntitySelectable<ServiceQtanItemPriceElement>
{

}
