/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
 * ServiceQtanItemRefObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.field.ServiceQtanItemRefObjectField
 * ServiceQtanItemRefObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.link.ServiceQtanItemRefObjectLink
 * ServiceQtanItemRefObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject#SERVICE_QUOTATION
 * SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject#SERVICE_QUOTATION_ITEM
 * SERVICE_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject#SERVICE_REFERENCE_EQUIPMENT
 * SERVICE_REFERENCE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject#SERVICE_REF_FUNCTIONAL_LOCATION
 * SERVICE_REF_FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject#SRVC_REF_OBJ_IS_MAIN_OBJECT
 * SRVC_REF_OBJ_IS_MAIN_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject#TO_SERVICE_QUOTATION
 * TO_SERVICE_QUOTATION}</li>
 * </ul>
 *
 */
public interface ServiceQtanItemRefObjectSelectable extends EntitySelectable<ServiceQtanItemRefObject>
{

}
