/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
 * ServiceQtanPersonResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.field.ServiceQtanPersonRespField
 * ServiceQtanPersonRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.link.ServiceQtanPersonRespLink
 * ServiceQtanPersonRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp#SERVICE_QUOTATION
 * SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * </ul>
 *
 */
public interface ServiceQtanPersonRespSelectable extends EntitySelectable<ServiceQtanPersonResp>
{

}
