/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.selectable.ServiceQtanFUPSrvcOrdSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanFUPSrvcOrd
 * ServiceQtanFUPSrvcOrd} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ServiceQtanFUPSrvcOrdByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceQtanFUPSrvcOrdByKeyFluentHelper, ServiceQtanFUPSrvcOrd, ServiceQtanFUPSrvcOrdSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanFUPSrvcOrd
     * ServiceQtanFUPSrvcOrd} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceQtanFUPSrvcOrd}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceQtanFUPSrvcOrd}
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ServiceQtanFUPSrvcOrdByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceQuotation,
        final String serviceOrder )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceQuotation", serviceQuotation);
        this.key.put("ServiceOrder", serviceOrder);
    }

    @Override
    @Nonnull
    protected Class<ServiceQtanFUPSrvcOrd> getEntityClass()
    {
        return ServiceQtanFUPSrvcOrd.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
