/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
 * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ServiceQtanItemPriceElementCreateFluentHelper
    extends
    FluentHelperCreate<ServiceQtanItemPriceElementCreateFluentHelper, ServiceQtanItemPriceElement>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity object that will be created in the S/4HANA system.
     *
     */
    private final ServiceQtanItemPriceElement entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The ServiceQtanItemPriceElement to create.
     */
    public ServiceQtanItemPriceElementCreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ServiceQtanItemPriceElement entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ServiceQtanItemPriceElement getEntity()
    {
        return entity;
    }

}
