/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.selectable.ServiceQtanPersonRespSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
 * ServiceQtanPersonResp} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class ServiceQtanPersonRespByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceQtanPersonRespByKeyFluentHelper, ServiceQtanPersonResp, ServiceQtanPersonRespSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceQtanPersonResp}
     * @param personResponsible
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceQtanPersonResp}
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ServiceQtanPersonRespByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceQuotation,
        final String personResponsible )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceQuotation", serviceQuotation);
        this.key.put("PersonResponsible", personResponsible);
    }

    @Override
    @Nonnull
    protected Class<ServiceQtanPersonResp> getEntityClass()
    {
        return ServiceQtanPersonResp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
