/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
 * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ServiceQtanPriceElementCreateFluentHelper
    extends
    FluentHelperCreate<ServiceQtanPriceElementCreateFluentHelper, ServiceQtanPriceElement>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity object that will be created in the S/4HANA system.
     *
     */
    private final ServiceQtanPriceElement entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The ServiceQtanPriceElement to create.
     */
    public ServiceQtanPriceElementCreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ServiceQtanPriceElement entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ServiceQtanPriceElement getEntity()
    {
        return entity;
    }

}
