/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
 * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ServiceQtanPriceElementUpdateFluentHelper
    extends
    FluentHelperUpdate<ServiceQtanPriceElementUpdateFluentHelper, ServiceQtanPriceElement>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity object that will be updated in the S/4HANA system.
     *
     */
    private final ServiceQtanPriceElement entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ServiceQtanPriceElement to take the updated values from.
     */
    public ServiceQtanPriceElementUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ServiceQtanPriceElement entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ServiceQtanPriceElement getEntity()
    {
        return entity;
    }

}
