/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.field.ServiceQuotationItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.link.ServiceQuotationItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.link.ServiceQuotationItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.selectable.ServiceQuotationItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Quotation Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceQuotationItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceQuotationItem extends VdmEntity<ServiceQuotationItem>
{

    /**
     * Selector for all available fields of ServiceQuotationItem.
     *
     */
    public final static ServiceQuotationItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceQuotation" )
    @JsonProperty( "ServiceQuotation" )
    @Nullable
    @ODataField( odataName = "ServiceQuotation" )
    private String serviceQuotation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotation</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QUOTATION =
        new ServiceQuotationItemField<String>("ServiceQuotation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceQuotationItem" )
    @JsonProperty( "ServiceQuotationItem" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationItem" )
    private String serviceQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationItem</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QUOTATION_ITEM =
        new ServiceQuotationItemField<String>("ServiceQuotationItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "ServiceDocItemCategory" )
    @JsonProperty( "ServiceDocItemCategory" )
    @Nullable
    @ODataField( odataName = "ServiceDocItemCategory" )
    private String serviceDocItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItemCategory</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_DOC_ITEM_CATEGORY =
        new ServiceQuotationItemField<String>("ServiceDocItemCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceQuotationItemUUID" )
    @JsonProperty( "ServiceQuotationItemUUID" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationItemUUID" )
    private UUID serviceQuotationItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationItemUUID</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<UUID> SERVICE_QUOTATION_ITEM_UUID =
        new ServiceQuotationItemField<UUID>("ServiceQuotationItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanItemDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ServiceQtanItemDescription" )
    @JsonProperty( "ServiceQtanItemDescription" )
    @Nullable
    @ODataField( odataName = "ServiceQtanItemDescription" )
    private String serviceQtanItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQtanItemDescription</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QTAN_ITEM_DESCRIPTION =
        new ServiceQuotationItemField<String>("ServiceQtanItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> LANGUAGE = new ServiceQuotationItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> PRODUCT = new ServiceQuotationItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> QUANTITY_UNIT =
        new ServiceQuotationItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<BigDecimal> QUANTITY =
        new ServiceQuotationItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDuration</b>
     * </p>
     *
     * @return Duration
     */
    @SerializedName( "ServiceDuration" )
    @JsonProperty( "ServiceDuration" )
    @Nullable
    @ODataField( odataName = "ServiceDuration" )
    private BigDecimal serviceDuration;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDuration</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<BigDecimal> SERVICE_DURATION =
        new ServiceQuotationItemField<BigDecimal>("ServiceDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDurationUnit</b>
     * </p>
     *
     * @return Unit for Duration of Work
     */
    @SerializedName( "ServiceDurationUnit" )
    @JsonProperty( "ServiceDurationUnit" )
    @Nullable
    @ODataField( odataName = "ServiceDurationUnit" )
    private String serviceDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDurationUnit</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_DURATION_UNIT =
        new ServiceQuotationItemField<String>("ServiceDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanItemExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ServiceQtanItemExtReference" )
    @JsonProperty( "ServiceQtanItemExtReference" )
    @Nullable
    @ODataField( odataName = "ServiceQtanItemExtReference" )
    private String serviceQtanItemExtReference;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQtanItemExtReference</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QTAN_ITEM_EXT_REFERENCE =
        new ServiceQuotationItemField<String>("ServiceQtanItemExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SOLD_TO_PARTY =
        new ServiceQuotationItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SHIP_TO_PARTY =
        new ServiceQuotationItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> PERSON_RESPONSIBLE =
        new ServiceQuotationItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_PERFORMER =
        new ServiceQuotationItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItemIsAccepted</b>
     * </p>
     *
     * @return The serviceQuotationItemIsAccepted contained in this entity.
     */
    @SerializedName( "ServiceQuotationItemIsAccepted" )
    @JsonProperty( "ServiceQuotationItemIsAccepted" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationItemIsAccepted" )
    private String serviceQuotationItemIsAccepted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationItemIsAccepted</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QUOTATION_ITEM_IS_ACCEPTED =
        new ServiceQuotationItemField<String>("ServiceQuotationItemIsAccepted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItemIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "ServiceQuotationItemIsRejected" )
    @JsonProperty( "ServiceQuotationItemIsRejected" )
    @Nullable
    @ODataField( odataName = "ServiceQuotationItemIsRejected" )
    private String serviceQuotationItemIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQuotationItemIsRejected</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QUOTATION_ITEM_IS_REJECTED =
        new ServiceQuotationItemField<String>("ServiceQuotationItemIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQtanItmRejectionReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "SrvcQtanItmRejectionReason" )
    @JsonProperty( "SrvcQtanItmRejectionReason" )
    @Nullable
    @ODataField( odataName = "SrvcQtanItmRejectionReason" )
    private String srvcQtanItmRejectionReason;
    /**
     * Use with available fluent helpers to apply the <b>SrvcQtanItmRejectionReason</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SRVC_QTAN_ITM_REJECTION_REASON =
        new ServiceQuotationItemField<String>("SrvcQtanItmRejectionReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @return Overtime Category
     */
    @SerializedName( "TimeSheetOvertimeCategory" )
    @JsonProperty( "TimeSheetOvertimeCategory" )
    @Nullable
    @ODataField( odataName = "TimeSheetOvertimeCategory" )
    private String timeSheetOvertimeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetOvertimeCategory</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> TIME_SHEET_OVERTIME_CATEGORY =
        new ServiceQuotationItemField<String>("TimeSheetOvertimeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceContract" )
    @JsonProperty( "ReferenceServiceContract" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContract" )
    private String referenceServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContract</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> REFERENCE_SERVICE_CONTRACT =
        new ServiceQuotationItemField<String>("ReferenceServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ReferenceServiceContractItem" )
    @JsonProperty( "ReferenceServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContractItem" )
    private String referenceServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContractItem</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> REFERENCE_SERVICE_CONTRACT_ITEM =
        new ServiceQuotationItemField<String>("ReferenceServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanSuccessorOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceQtanSuccessorOrder" )
    @JsonProperty( "ServiceQtanSuccessorOrder" )
    @Nullable
    @ODataField( odataName = "ServiceQtanSuccessorOrder" )
    private String serviceQtanSuccessorOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQtanSuccessorOrder</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QTAN_SUCCESSOR_ORDER =
        new ServiceQuotationItemField<String>("ServiceQtanSuccessorOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanSuccessorOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ServiceQtanSuccessorOrderItem" )
    @JsonProperty( "ServiceQtanSuccessorOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceQtanSuccessorOrderItem" )
    private String serviceQtanSuccessorOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceQtanSuccessorOrderItem</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> SERVICE_QTAN_SUCCESSOR_ORDER_ITEM =
        new ServiceQuotationItemField<String>("ServiceQtanSuccessorOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceQuotationItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ParentServiceQuotationItem" )
    @JsonProperty( "ParentServiceQuotationItem" )
    @Nullable
    @ODataField( odataName = "ParentServiceQuotationItem" )
    private String parentServiceQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>ParentServiceQuotationItem</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> PARENT_SERVICE_QUOTATION_ITEM =
        new ServiceQuotationItemField<String>("ParentServiceQuotationItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> PAYMENT_TERMS =
        new ServiceQuotationItemField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @return Service Team (Responsibility Management)
     */
    @SerializedName( "RespyMgmtServiceTeam" )
    @JsonProperty( "RespyMgmtServiceTeam" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeam" )
    private String respyMgmtServiceTeam;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeam</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> RESPY_MGMT_SERVICE_TEAM =
        new ServiceQuotationItemField<String>("RespyMgmtServiceTeam");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "RespyMgmtServiceTeamName" )
    @JsonProperty( "RespyMgmtServiceTeamName" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeamName" )
    private String respyMgmtServiceTeamName;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeamName</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> RESPY_MGMT_SERVICE_TEAM_NAME =
        new ServiceQuotationItemField<String>("RespyMgmtServiceTeamName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @return Global Team ID in Responsibility Mgmt.
     */
    @SerializedName( "RespyMgmtGlobalTeamID" )
    @JsonProperty( "RespyMgmtGlobalTeamID" )
    @Nullable
    @ODataField( odataName = "RespyMgmtGlobalTeamID" )
    private String respyMgmtGlobalTeamID;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtGlobalTeamID</b> field to query operations.
     *
     */
    public final static ServiceQuotationItemField<String> RESPY_MGMT_GLOBAL_TEAM_ID =
        new ServiceQuotationItemField<String>("RespyMgmtGlobalTeamID");
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceQuotationItem</b> to multiple
     * <b>ServiceQtanItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQtanItemPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceQuotationItem</b> to multiple
     * <b>ServiceQtanItemRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQtanItemRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_ServiceQuotation</b> for <b>ServiceQuotationItem</b> to single <b>ServiceQuotation</b>.
     *
     */
    @SerializedName( "to_ServiceQuotation" )
    @JsonProperty( "to_ServiceQuotation" )
    @ODataField( odataName = "to_ServiceQuotation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceQuotation toServiceQuotation;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceQuotationItem</b> to multiple <b>ServiceQuotationItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceQuotationItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationItemLink<ServiceQtanItemPriceElement> TO_PRICING_ELEMENT =
        new ServiceQuotationItemLink<ServiceQtanItemPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationItemLink<ServiceQtanItemRefObject> TO_REFERENCE_OBJECT =
        new ServiceQuotationItemLink<ServiceQtanItemRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceQuotation</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceQuotationItemOneToOneLink<ServiceQuotation> TO_SERVICE_QUOTATION =
        new ServiceQuotationItemOneToOneLink<ServiceQuotation>("to_ServiceQuotation");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceQuotationItemLink<ServiceQuotationItemText> TO_TEXT =
        new ServiceQuotationItemLink<ServiceQuotationItemText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceQuotationItem> getType()
    {
        return ServiceQuotationItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotation</b>
     * </p>
     *
     * @param serviceQuotation
     *            Transaction ID
     */
    public void setServiceQuotation( @Nullable final String serviceQuotation )
    {
        rememberChangedField("ServiceQuotation", this.serviceQuotation);
        this.serviceQuotation = serviceQuotation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItem</b>
     * </p>
     *
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     */
    public void setServiceQuotationItem( @Nullable final String serviceQuotationItem )
    {
        rememberChangedField("ServiceQuotationItem", this.serviceQuotationItem);
        this.serviceQuotationItem = serviceQuotationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItemCategory</b>
     * </p>
     *
     * @param serviceDocItemCategory
     *            Item Category
     */
    public void setServiceDocItemCategory( @Nullable final String serviceDocItemCategory )
    {
        rememberChangedField("ServiceDocItemCategory", this.serviceDocItemCategory);
        this.serviceDocItemCategory = serviceDocItemCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItemUUID</b>
     * </p>
     *
     * @param serviceQuotationItemUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceQuotationItemUUID( @Nullable final UUID serviceQuotationItemUUID )
    {
        rememberChangedField("ServiceQuotationItemUUID", this.serviceQuotationItemUUID);
        this.serviceQuotationItemUUID = serviceQuotationItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanItemDescription</b>
     * </p>
     *
     * @param serviceQtanItemDescription
     *            Product Description
     */
    public void setServiceQtanItemDescription( @Nullable final String serviceQtanItemDescription )
    {
        rememberChangedField("ServiceQtanItemDescription", this.serviceQtanItemDescription);
        this.serviceQtanItemDescription = serviceQtanItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDuration</b>
     * </p>
     *
     * @param serviceDuration
     *            Duration
     */
    public void setServiceDuration( @Nullable final BigDecimal serviceDuration )
    {
        rememberChangedField("ServiceDuration", this.serviceDuration);
        this.serviceDuration = serviceDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDurationUnit</b>
     * </p>
     *
     * @param serviceDurationUnit
     *            Unit for Duration of Work
     */
    public void setServiceDurationUnit( @Nullable final String serviceDurationUnit )
    {
        rememberChangedField("ServiceDurationUnit", this.serviceDurationUnit);
        this.serviceDurationUnit = serviceDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanItemExtReference</b>
     * </p>
     *
     * @param serviceQtanItemExtReference
     *            External Reference Number
     */
    public void setServiceQtanItemExtReference( @Nullable final String serviceQtanItemExtReference )
    {
        rememberChangedField("ServiceQtanItemExtReference", this.serviceQtanItemExtReference);
        this.serviceQtanItemExtReference = serviceQtanItemExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Business Partner Number
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItemIsAccepted</b>
     * </p>
     *
     * @param serviceQuotationItemIsAccepted
     *            The serviceQuotationItemIsAccepted to set.
     */
    public void setServiceQuotationItemIsAccepted( @Nullable final String serviceQuotationItemIsAccepted )
    {
        rememberChangedField("ServiceQuotationItemIsAccepted", this.serviceQuotationItemIsAccepted);
        this.serviceQuotationItemIsAccepted = serviceQuotationItemIsAccepted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQuotationItemIsRejected</b>
     * </p>
     *
     * @param serviceQuotationItemIsRejected
     *            Cancellation Status
     */
    public void setServiceQuotationItemIsRejected( @Nullable final String serviceQuotationItemIsRejected )
    {
        rememberChangedField("ServiceQuotationItemIsRejected", this.serviceQuotationItemIsRejected);
        this.serviceQuotationItemIsRejected = serviceQuotationItemIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcQtanItmRejectionReason</b>
     * </p>
     *
     * @param srvcQtanItmRejectionReason
     *            Cancellation Reason Code
     */
    public void setSrvcQtanItmRejectionReason( @Nullable final String srvcQtanItmRejectionReason )
    {
        rememberChangedField("SrvcQtanItmRejectionReason", this.srvcQtanItmRejectionReason);
        this.srvcQtanItmRejectionReason = srvcQtanItmRejectionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *            Overtime Category
     */
    public void setTimeSheetOvertimeCategory( @Nullable final String timeSheetOvertimeCategory )
    {
        rememberChangedField("TimeSheetOvertimeCategory", this.timeSheetOvertimeCategory);
        this.timeSheetOvertimeCategory = timeSheetOvertimeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @param referenceServiceContract
     *            Transaction ID
     */
    public void setReferenceServiceContract( @Nullable final String referenceServiceContract )
    {
        rememberChangedField("ReferenceServiceContract", this.referenceServiceContract);
        this.referenceServiceContract = referenceServiceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @param referenceServiceContractItem
     *            Shortened Item Number in Document
     */
    public void setReferenceServiceContractItem( @Nullable final String referenceServiceContractItem )
    {
        rememberChangedField("ReferenceServiceContractItem", this.referenceServiceContractItem);
        this.referenceServiceContractItem = referenceServiceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanSuccessorOrder</b>
     * </p>
     *
     * @param serviceQtanSuccessorOrder
     *            Transaction ID
     */
    public void setServiceQtanSuccessorOrder( @Nullable final String serviceQtanSuccessorOrder )
    {
        rememberChangedField("ServiceQtanSuccessorOrder", this.serviceQtanSuccessorOrder);
        this.serviceQtanSuccessorOrder = serviceQtanSuccessorOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceQtanSuccessorOrderItem</b>
     * </p>
     *
     * @param serviceQtanSuccessorOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceQtanSuccessorOrderItem( @Nullable final String serviceQtanSuccessorOrderItem )
    {
        rememberChangedField("ServiceQtanSuccessorOrderItem", this.serviceQtanSuccessorOrderItem);
        this.serviceQtanSuccessorOrderItem = serviceQtanSuccessorOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceQuotationItem</b>
     * </p>
     *
     * @param parentServiceQuotationItem
     *            Shortened Item Number in Document
     */
    public void setParentServiceQuotationItem( @Nullable final String parentServiceQuotationItem )
    {
        rememberChangedField("ParentServiceQuotationItem", this.parentServiceQuotationItem);
        this.parentServiceQuotationItem = parentServiceQuotationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @param respyMgmtServiceTeam
     *            Service Team (Responsibility Management)
     */
    public void setRespyMgmtServiceTeam( @Nullable final String respyMgmtServiceTeam )
    {
        rememberChangedField("RespyMgmtServiceTeam", this.respyMgmtServiceTeam);
        this.respyMgmtServiceTeam = respyMgmtServiceTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @param respyMgmtServiceTeamName
     *            Name
     */
    public void setRespyMgmtServiceTeamName( @Nullable final String respyMgmtServiceTeamName )
    {
        rememberChangedField("RespyMgmtServiceTeamName", this.respyMgmtServiceTeamName);
        this.respyMgmtServiceTeamName = respyMgmtServiceTeamName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceQuotationItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceQuotation", getServiceQuotation());
        result.put("ServiceQuotationItem", getServiceQuotationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceQuotation", getServiceQuotation());
        values.put("ServiceQuotationItem", getServiceQuotationItem());
        values.put("ServiceDocItemCategory", getServiceDocItemCategory());
        values.put("ServiceQuotationItemUUID", getServiceQuotationItemUUID());
        values.put("ServiceQtanItemDescription", getServiceQtanItemDescription());
        values.put("Language", getLanguage());
        values.put("Product", getProduct());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("Quantity", getQuantity());
        values.put("ServiceDuration", getServiceDuration());
        values.put("ServiceDurationUnit", getServiceDurationUnit());
        values.put("ServiceQtanItemExtReference", getServiceQtanItemExtReference());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ServicePerformer", getServicePerformer());
        values.put("ServiceQuotationItemIsAccepted", getServiceQuotationItemIsAccepted());
        values.put("ServiceQuotationItemIsRejected", getServiceQuotationItemIsRejected());
        values.put("SrvcQtanItmRejectionReason", getSrvcQtanItmRejectionReason());
        values.put("TimeSheetOvertimeCategory", getTimeSheetOvertimeCategory());
        values.put("ReferenceServiceContract", getReferenceServiceContract());
        values.put("ReferenceServiceContractItem", getReferenceServiceContractItem());
        values.put("ServiceQtanSuccessorOrder", getServiceQtanSuccessorOrder());
        values.put("ServiceQtanSuccessorOrderItem", getServiceQtanSuccessorOrderItem());
        values.put("ParentServiceQuotationItem", getParentServiceQuotationItem());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("RespyMgmtServiceTeam", getRespyMgmtServiceTeam());
        values.put("RespyMgmtServiceTeamName", getRespyMgmtServiceTeamName());
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceQuotation") ) {
                final Object value = values.remove("ServiceQuotation");
                if( (value == null) || (!value.equals(getServiceQuotation())) ) {
                    setServiceQuotation(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationItem") ) {
                final Object value = values.remove("ServiceQuotationItem");
                if( (value == null) || (!value.equals(getServiceQuotationItem())) ) {
                    setServiceQuotationItem(((String) value));
                }
            }
            if( values.containsKey("ServiceDocItemCategory") ) {
                final Object value = values.remove("ServiceDocItemCategory");
                if( (value == null) || (!value.equals(getServiceDocItemCategory())) ) {
                    setServiceDocItemCategory(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationItemUUID") ) {
                final Object value = values.remove("ServiceQuotationItemUUID");
                if( (value == null) || (!value.equals(getServiceQuotationItemUUID())) ) {
                    setServiceQuotationItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceQtanItemDescription") ) {
                final Object value = values.remove("ServiceQtanItemDescription");
                if( (value == null) || (!value.equals(getServiceQtanItemDescription())) ) {
                    setServiceQtanItemDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDuration") ) {
                final Object value = values.remove("ServiceDuration");
                if( (value == null) || (!value.equals(getServiceDuration())) ) {
                    setServiceDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDurationUnit") ) {
                final Object value = values.remove("ServiceDurationUnit");
                if( (value == null) || (!value.equals(getServiceDurationUnit())) ) {
                    setServiceDurationUnit(((String) value));
                }
            }
            if( values.containsKey("ServiceQtanItemExtReference") ) {
                final Object value = values.remove("ServiceQtanItemExtReference");
                if( (value == null) || (!value.equals(getServiceQtanItemExtReference())) ) {
                    setServiceQtanItemExtReference(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationItemIsAccepted") ) {
                final Object value = values.remove("ServiceQuotationItemIsAccepted");
                if( (value == null) || (!value.equals(getServiceQuotationItemIsAccepted())) ) {
                    setServiceQuotationItemIsAccepted(((String) value));
                }
            }
            if( values.containsKey("ServiceQuotationItemIsRejected") ) {
                final Object value = values.remove("ServiceQuotationItemIsRejected");
                if( (value == null) || (!value.equals(getServiceQuotationItemIsRejected())) ) {
                    setServiceQuotationItemIsRejected(((String) value));
                }
            }
            if( values.containsKey("SrvcQtanItmRejectionReason") ) {
                final Object value = values.remove("SrvcQtanItmRejectionReason");
                if( (value == null) || (!value.equals(getSrvcQtanItmRejectionReason())) ) {
                    setSrvcQtanItmRejectionReason(((String) value));
                }
            }
            if( values.containsKey("TimeSheetOvertimeCategory") ) {
                final Object value = values.remove("TimeSheetOvertimeCategory");
                if( (value == null) || (!value.equals(getTimeSheetOvertimeCategory())) ) {
                    setTimeSheetOvertimeCategory(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContract") ) {
                final Object value = values.remove("ReferenceServiceContract");
                if( (value == null) || (!value.equals(getReferenceServiceContract())) ) {
                    setReferenceServiceContract(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContractItem") ) {
                final Object value = values.remove("ReferenceServiceContractItem");
                if( (value == null) || (!value.equals(getReferenceServiceContractItem())) ) {
                    setReferenceServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("ServiceQtanSuccessorOrder") ) {
                final Object value = values.remove("ServiceQtanSuccessorOrder");
                if( (value == null) || (!value.equals(getServiceQtanSuccessorOrder())) ) {
                    setServiceQtanSuccessorOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceQtanSuccessorOrderItem") ) {
                final Object value = values.remove("ServiceQtanSuccessorOrderItem");
                if( (value == null) || (!value.equals(getServiceQtanSuccessorOrderItem())) ) {
                    setServiceQtanSuccessorOrderItem(((String) value));
                }
            }
            if( values.containsKey("ParentServiceQuotationItem") ) {
                final Object value = values.remove("ParentServiceQuotationItem");
                if( (value == null) || (!value.equals(getParentServiceQuotationItem())) ) {
                    setParentServiceQuotationItem(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeam") ) {
                final Object value = values.remove("RespyMgmtServiceTeam");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeam())) ) {
                    setRespyMgmtServiceTeam(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeamName") ) {
                final Object value = values.remove("RespyMgmtServiceTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeamName())) ) {
                    setRespyMgmtServiceTeamName(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQtanItemPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceQtanItemPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQtanItemRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceQtanItemRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceQuotation") ) {
                final Object value = (values).remove("to_ServiceQuotation");
                if( value instanceof Map ) {
                    if( toServiceQuotation == null ) {
                        toServiceQuotation = new ServiceQuotation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceQuotation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceQuotationItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceQuotationItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceQuotationItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceQuotationItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceQuotationItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceQuotationItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toServiceQuotation != null ) {
            (values).put("to_ServiceQuotation", toServiceQuotation);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceQtanItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQtanItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanItemPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceQtanItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceQtanItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceQuotationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQtanItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanItemPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceQtanItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotationItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceQtanItemPriceElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceQtanItemPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceQtanItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceQuotationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQtanItemPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceQtanItemPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQtanItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceQuotationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQtanItemPriceElement</b> entities.
     */
    public void addPricingElement( ServiceQtanItemPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceQtanItemRefObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQtanItemRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanItemRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceQtanItemRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceQtanItemRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceQuotationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQtanItemRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQtanItemRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceQtanItemRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotationItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceQtanItemRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceQtanItemRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceQtanItemRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceQuotationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQtanItemRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceQtanItemRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQtanItemRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceQuotationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQtanItemRefObject</b> entities.
     */
    public void addReferenceObject( ServiceQtanItemRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceQuotation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceQuotation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceQuotation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceQuotation fetchServiceQuotation()
    {
        return fetchFieldAsSingle("to_ServiceQuotation", ServiceQuotation.class);
    }

    /**
     * Retrieval of associated <b>ServiceQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceQuotation</b>.
     * <p>
     * If the navigation property <b>to_ServiceQuotation</b> of a queried <b>ServiceQuotationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQuotation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceQuotation getServiceQuotationOrFetch()
    {
        if( toServiceQuotation == null ) {
            toServiceQuotation = fetchServiceQuotation();
        }
        return toServiceQuotation;
    }

    /**
     * Retrieval of associated <b>ServiceQuotation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceQuotation</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotationItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceQuotation</b> is already loaded, the result will
     *         contain the <b>ServiceQuotation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceQuotation> getServiceQuotationIfPresent()
    {
        return Option.of(toServiceQuotation);
    }

    /**
     * Overwrites the associated <b>ServiceQuotation</b> entity for the loaded navigation property
     * <b>to_ServiceQuotation</b>.
     *
     * @param value
     *            New <b>ServiceQuotation</b> entity.
     */
    public void setServiceQuotation( final ServiceQuotation value )
    {
        toServiceQuotation = value;
    }

    /**
     * Fetches the <b>ServiceQuotationItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceQuotationItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQuotationItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceQuotationItemText.class);
    }

    /**
     * Retrieval of associated <b>ServiceQuotationItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceQuotationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceQuotationItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceQuotationItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceQuotationItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceQuotationItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceQuotationItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceQuotationItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceQuotationItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceQuotationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceQuotationItemText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceQuotationItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceQuotationItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceQuotationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceQuotationItemText</b> entities.
     */
    public void addText( ServiceQuotationItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceQuotationItem instances.
     *
     */
    public final static class ServiceQuotationItemBuilder
    {

        private List<ServiceQtanItemPriceElement> toPricingElement = Lists.newArrayList();
        private List<ServiceQtanItemRefObject> toReferenceObject = Lists.newArrayList();
        private ServiceQuotation toServiceQuotation;
        private String serviceQuotation = null;
        private List<ServiceQuotationItemText> toText = Lists.newArrayList();

        private ServiceQuotationItem.ServiceQuotationItemBuilder toPricingElement(
            final List<ServiceQtanItemPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceQuotationItem</b> to multiple
         * <b>ServiceQtanItemPriceElement</b>.
         *
         * @param value
         *            The ServiceQtanItemPriceElements to build this ServiceQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotationItem.ServiceQuotationItemBuilder pricingElement( ServiceQtanItemPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceQuotationItem.ServiceQuotationItemBuilder toReferenceObject(
            final List<ServiceQtanItemRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceQuotationItem</b> to multiple
         * <b>ServiceQtanItemRefObject</b>.
         *
         * @param value
         *            The ServiceQtanItemRefObjects to build this ServiceQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotationItem.ServiceQuotationItemBuilder referenceObject( ServiceQtanItemRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceQuotationItem.ServiceQuotationItemBuilder toServiceQuotation( final ServiceQuotation value )
        {
            toServiceQuotation = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceQuotation</b> for <b>ServiceQuotationItem</b> to single
         * <b>ServiceQuotation</b>.
         *
         * @param value
         *            The ServiceQuotation to build this ServiceQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotationItem.ServiceQuotationItemBuilder serviceQuotation( final ServiceQuotation value )
        {
            return toServiceQuotation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceQuotation</b>
         * </p>
         *
         * @param value
         *            The serviceQuotation to build this ServiceQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotationItem.ServiceQuotationItemBuilder serviceQuotation( final String value )
        {
            serviceQuotation = value;
            return this;
        }

        private ServiceQuotationItem.ServiceQuotationItemBuilder toText( final List<ServiceQuotationItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceQuotationItem</b> to multiple
         * <b>ServiceQuotationItemText</b>.
         *
         * @param value
         *            The ServiceQuotationItemTexts to build this ServiceQuotationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceQuotationItem.ServiceQuotationItemBuilder text( ServiceQuotationItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
