/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText;

/**
 * Implementation of the {@link ServiceQuotationV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationV2Service ServiceQuotationV2Service}.
 *
 */
public class DefaultServiceQuotationV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ServiceQuotationV2ServiceBatch, ServiceQuotationV2ServiceBatchChangeSet>
    implements
    ServiceQuotationV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultServiceQuotationV2ServiceBatchChangeSet(
        @Nonnull final DefaultServiceQuotationV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultServiceQuotationV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return addRequestCreate(service::createServiceQtanItemPriceElement, serviceQtanItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return addRequestUpdate(service::updateServiceQtanItemPriceElement, serviceQtanItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQtanItemPriceElement(
        @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement )
    {
        return addRequestDelete(service::deleteServiceQtanItemPriceElement, serviceQtanItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQtanItemRefObject(
        @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject )
    {
        return addRequestCreate(service::createServiceQtanItemRefObject, serviceQtanItemRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQtanItemRefObject(
        @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject )
    {
        return addRequestDelete(service::deleteServiceQtanItemRefObject, serviceQtanItemRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return addRequestCreate(service::createServiceQtanPersonResp, serviceQtanPersonResp);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return addRequestUpdate(service::updateServiceQtanPersonResp, serviceQtanPersonResp);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQtanPersonResp(
        @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp )
    {
        return addRequestDelete(service::deleteServiceQtanPersonResp, serviceQtanPersonResp);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return addRequestCreate(service::createServiceQtanPriceElement, serviceQtanPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return addRequestUpdate(service::updateServiceQtanPriceElement, serviceQtanPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQtanPriceElement(
        @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement )
    {
        return addRequestDelete(service::deleteServiceQtanPriceElement, serviceQtanPriceElement);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQtanRefObject(
        @Nonnull final ServiceQtanRefObject serviceQtanRefObject )
    {
        return addRequestCreate(service::createServiceQtanRefObject, serviceQtanRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQtanRefObject(
        @Nonnull final ServiceQtanRefObject serviceQtanRefObject )
    {
        return addRequestDelete(service::deleteServiceQtanRefObject, serviceQtanRefObject);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQuotation(
        @Nonnull final ServiceQuotation serviceQuotation )
    {
        return addRequestCreate(service::createServiceQuotation, serviceQuotation);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQuotation(
        @Nonnull final ServiceQuotation serviceQuotation )
    {
        return addRequestUpdate(service::updateServiceQuotation, serviceQuotation);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return addRequestCreate(service::createServiceQuotationItem, serviceQuotationItem);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return addRequestUpdate(service::updateServiceQuotationItem, serviceQuotationItem);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQuotationItem(
        @Nonnull final ServiceQuotationItem serviceQuotationItem )
    {
        return addRequestDelete(service::deleteServiceQuotationItem, serviceQuotationItem);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return addRequestCreate(service::createServiceQuotationItemText, serviceQuotationItemText);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return addRequestUpdate(service::updateServiceQuotationItemText, serviceQuotationItemText);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQuotationItemText(
        @Nonnull final ServiceQuotationItemText serviceQuotationItemText )
    {
        return addRequestDelete(service::deleteServiceQuotationItemText, serviceQuotationItemText);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet createServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return addRequestCreate(service::createServiceQuotationText, serviceQuotationText);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet updateServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return addRequestUpdate(service::updateServiceQuotationText, serviceQuotationText);
    }

    @Nonnull
    @Override
    public ServiceQuotationV2ServiceBatchChangeSet deleteServiceQuotationText(
        @Nonnull final ServiceQuotationText serviceQuotationText )
    {
        return addRequestDelete(service::deleteServiceQuotationText, serviceQuotationText);
    }

}
