/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceQuotationV2Service
 * ServiceQuotationV2Service}.
 *
 */
public interface ServiceQuotationV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ServiceQuotationV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ServiceQuotationV2ServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        updateServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity in the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemRefObject
     *            ServiceQtanItemRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQtanItemRefObject( @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity in the S/4HANA system.
     *
     * @param serviceQtanItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanItemRefObject
     *            ServiceQtanItemRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQtanItemRefObject( @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        updateServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity in the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        updateServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity in the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanRefObject
     * ServiceQtanRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanRefObject
     *            ServiceQtanRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQtanRefObject( @Nonnull final ServiceQtanRefObject serviceQtanRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanRefObject
     * ServiceQtanRefObject} entity in the S/4HANA system.
     *
     * @param serviceQtanRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanRefObject
     *            ServiceQtanRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQtanRefObject( @Nonnull final ServiceQtanRefObject serviceQtanRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation
     * ServiceQuotation} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation
     *            ServiceQuotation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet createServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation
     * ServiceQuotation} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation
     *            ServiceQuotation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet updateServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
     * ServiceQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
     * ServiceQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        updateServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
     * ServiceQuotationItem} entity in the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText
     * ServiceQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText
     * ServiceQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        updateServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText
     * ServiceQuotationItemText} entity in the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText
     * ServiceQuotationText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        createServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText
     * ServiceQuotationText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        updateServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText
     * ServiceQuotationText} entity in the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceQuotationV2ServiceBatchChangeSet
        deleteServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

}
