/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanFUPSrvcOrd;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanFUPSrvcOrd
 * ServiceQtanFUPSrvcOrd}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.field.ServiceQtanFUPSrvcOrdField
 * ServiceQtanFUPSrvcOrdField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.link.ServiceQtanFUPSrvcOrdLink
 * ServiceQtanFUPSrvcOrdLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanFUPSrvcOrd#SERVICE_QUOTATION
 * SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQtanFUPSrvcOrd#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * </ul>
 *
 */
public interface ServiceQtanFUPSrvcOrdSelectable extends EntitySelectable<ServiceQtanFUPSrvcOrd>
{

}
