/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem
 * ServiceQuotationItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.field.ServiceQuotationItemField
 * ServiceQuotationItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.link.ServiceQuotationItemLink
 * ServiceQuotationItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QUOTATION
 * SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QUOTATION_ITEM
 * SERVICE_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_DOC_ITEM_CATEGORY
 * SERVICE_DOC_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QUOTATION_ITEM_UUID
 * SERVICE_QUOTATION_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QTAN_ITEM_DESCRIPTION
 * SERVICE_QTAN_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_DURATION
 * SERVICE_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_DURATION_UNIT
 * SERVICE_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QTAN_ITEM_EXT_REFERENCE
 * SERVICE_QTAN_ITEM_EXT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_PERFORMER
 * SERVICE_PERFORMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QUOTATION_ITEM_IS_ACCEPTED
 * SERVICE_QUOTATION_ITEM_IS_ACCEPTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QUOTATION_ITEM_IS_REJECTED
 * SERVICE_QUOTATION_ITEM_IS_REJECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SRVC_QTAN_ITM_REJECTION_REASON
 * SRVC_QTAN_ITM_REJECTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#TIME_SHEET_OVERTIME_CATEGORY
 * TIME_SHEET_OVERTIME_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#REFERENCE_SERVICE_CONTRACT
 * REFERENCE_SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#REFERENCE_SERVICE_CONTRACT_ITEM
 * REFERENCE_SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QTAN_SUCCESSOR_ORDER
 * SERVICE_QTAN_SUCCESSOR_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#SERVICE_QTAN_SUCCESSOR_ORDER_ITEM
 * SERVICE_QTAN_SUCCESSOR_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#PARENT_SERVICE_QUOTATION_ITEM
 * PARENT_SERVICE_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#RESPY_MGMT_SERVICE_TEAM
 * RESPY_MGMT_SERVICE_TEAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#RESPY_MGMT_SERVICE_TEAM_NAME
 * RESPY_MGMT_SERVICE_TEAM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#RESPY_MGMT_GLOBAL_TEAM_ID
 * RESPY_MGMT_GLOBAL_TEAM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#TO_REFERENCE_OBJECT
 * TO_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#TO_SERVICE_QUOTATION
 * TO_SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotationItem#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceQuotationItemSelectable extends EntitySelectable<ServiceQuotationItem>
{

}
