/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation ServiceQuotation}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.field.ServiceQuotationField
 * ServiceQuotationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.link.ServiceQuotationLink
 * ServiceQuotationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION
 * SERVICE_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION_TYPE
 * SERVICE_QUOTATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION_UUID
 * SERVICE_QUOTATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION_DESCRIPTION
 * SERVICE_QUOTATION_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#REQUESTED_SERVICE_START_DATE_TIME
 * REQUESTED_SERVICE_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#REQUESTED_SERVICE_END_DATE_TIME
 * REQUESTED_SERVICE_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SRVC_QTAN_VALIDITY_START_DATE_TIME
 * SRVC_QTAN_VALIDITY_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SRVC_QTAN_VALIDITY_END_DATE_TIME
 * SRVC_QTAN_VALIDITY_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QTAN_EXT_REFERENCE
 * SERVICE_QTAN_EXT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION_IS_RELEASED
 * SERVICE_QUOTATION_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION_IS_ACCEPTED
 * SERVICE_QUOTATION_IS_ACCEPTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QUOTATION_IS_REJECTED
 * SERVICE_QUOTATION_IS_REJECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SRVC_QUOTATION_REJECTION_REASON
 * SRVC_QUOTATION_REJECTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_QTAN_SUCCESSOR_ORDER
 * SERVICE_QTAN_SUCCESSOR_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#RESPY_MGMT_SERVICE_TEAM
 * RESPY_MGMT_SERVICE_TEAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#RESPY_MGMT_SERVICE_TEAM_NAME
 * RESPY_MGMT_SERVICE_TEAM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#RESPY_MGMT_GLOBAL_TEAM_ID
 * RESPY_MGMT_GLOBAL_TEAM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_DOC_GROSS_AMOUNT
 * SERVICE_DOC_GROSS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_DOC_NET_AMOUNT
 * SERVICE_DOC_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#SERVICE_DOC_TAX_AMOUNT
 * SERVICE_DOC_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#REFERENCE_IN_HOUSE_REPAIR
 * REFERENCE_IN_HOUSE_REPAIR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TO_FOLLOW_UP_SERVICE_ORDER
 * TO_FOLLOW_UP_SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TO_ITEM
 * TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TO_PERSON_RESPONSIBLE
 * TO_PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TO_REFERENCE_OBJECT
 * TO_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotationv2.ServiceQuotation#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceQuotationSelectable extends EntitySelectable<ServiceQuotation>
{

}
