/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.field.DelivSchedSoldToPartyDetnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.selectable.DelivSchedSoldToPartyDetnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sold-to Party Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DelivSchedSoldToPartyDetnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DelivSchedSoldToPartyDetn extends VdmEntity<DelivSchedSoldToPartyDetn>
{

    /**
     * Selector for all available fields of DelivSchedSoldToPartyDetn.
     *
     */
    public final static DelivSchedSoldToPartyDetnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier Number at Customer Location
     */
    @Key
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static DelivSchedSoldToPartyDetnField<String> SUPPLIER =
        new DelivSchedSoldToPartyDetnField<String>("Supplier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerDescription</b>
     * </p>
     *
     * @return Cust.-Specif. Descr. of Business Partner (Plant, Stor. Loc.)
     */
    @Key
    @SerializedName( "PartnerDescription" )
    @JsonProperty( "PartnerDescription" )
    @Nullable
    @ODataField( odataName = "PartnerDescription" )
    private String partnerDescription;
    /**
     * Use with available fluent helpers to apply the <b>PartnerDescription</b> field to query operations.
     *
     */
    public final static DelivSchedSoldToPartyDetnField<String> PARTNER_DESCRIPTION =
        new DelivSchedSoldToPartyDetnField<String>("PartnerDescription");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @Key
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static DelivSchedSoldToPartyDetnField<String> UNLOADING_POINT_NAME =
        new DelivSchedSoldToPartyDetnField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static DelivSchedSoldToPartyDetnField<String> SOLD_TO_PARTY =
        new DelivSchedSoldToPartyDetnField<String>("SoldToParty");

    @Nonnull
    @Override
    public Class<DelivSchedSoldToPartyDetn> getType()
    {
        return DelivSchedSoldToPartyDetn.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier Number at Customer Location
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PartnerDescription</b>
     * </p>
     *
     * @param partnerDescription
     *            Cust.-Specif. Descr. of Business Partner (Plant, Stor. Loc.)
     */
    public void setPartnerDescription( @Nullable final String partnerDescription )
    {
        rememberChangedField("PartnerDescription", this.partnerDescription);
        this.partnerDescription = partnerDescription;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DelivSchedSoldToPartyDetn";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Supplier", getSupplier());
        result.put("PartnerDescription", getPartnerDescription());
        result.put("UnloadingPointName", getUnloadingPointName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Supplier", getSupplier());
        values.put("PartnerDescription", getPartnerDescription());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("SoldToParty", getSoldToParty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("PartnerDescription") ) {
                final Object value = values.remove("PartnerDescription");
                if( (value == null) || (!value.equals(getPartnerDescription())) ) {
                    setPartnerDescription(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DelivSchedSoldToPartyDetnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DelivSchedSoldToPartyDetnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DelivSchedSoldToPartyDetnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DelivSchedSoldToPartyDetnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

}
