/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.selectable.DelivSchedSoldToPartyDetnSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn
 * DelivSchedSoldToPartyDetn} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class DelivSchedSoldToPartyDetnByKeyFluentHelper
    extends
    FluentHelperByKey<DelivSchedSoldToPartyDetnByKeyFluentHelper, DelivSchedSoldToPartyDetn, DelivSchedSoldToPartyDetnSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn
     * DelivSchedSoldToPartyDetn} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code DelivSchedSoldToPartyDetn}
     * @param unloadingPointName
     *            Unloading Point
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code DelivSchedSoldToPartyDetn}
     * @param supplier
     *            Supplier Number at Customer Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 17
     *            </p>
     * @param partnerDescription
     *            Cust.-Specif. Descr. of Business Partner (Plant, Stor. Loc.)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public DelivSchedSoldToPartyDetnByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplier,
        final String partnerDescription,
        final String unloadingPointName )
    {
        super(servicePath, entityCollection);
        this.key.put("Supplier", supplier);
        this.key.put("PartnerDescription", partnerDescription);
        this.key.put("UnloadingPointName", unloadingPointName);
    }

    @Override
    @Nonnull
    protected Class<DelivSchedSoldToPartyDetn> getEntityClass()
    {
        return DelivSchedSoldToPartyDetn.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
