/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch} interface exposed
 * in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService
 * SoldToPartyAssignmentOfSalesSchedulingAgreementService}, allowing you to create multiple changesets and finally
 * execute the batch request.
 *
 */
public class DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch
    extends
    BatchFluentHelperBasic<SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch, SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet>
    implements
    SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet(this, service);
    }

}
