/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet} interface,
 * enabling you to combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService
 * SoldToPartyAssignmentOfSalesSchedulingAgreementService}.
 *
 */
public class DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch, SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet>
    implements
    SoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService service;

    @SuppressWarnings( "deprecation" )
    DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet(
        @Nonnull final DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SoldToPartyAssignmentOfSalesSchedulingAgreementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSoldToPartyAssignmentOfSalesSchedulingAgreementServiceBatchChangeSet getThis()
    {
        return this;
    }

}
