/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn
 * DelivSchedSoldToPartyDetn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.field.DelivSchedSoldToPartyDetnField
 * DelivSchedSoldToPartyDetnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.link.DelivSchedSoldToPartyDetnLink
 * DelivSchedSoldToPartyDetnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn#PARTNER_DESCRIPTION
 * PARTNER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.soldtopartyassignmentofsalesschedulingagreement.DelivSchedSoldToPartyDetn#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * </ul>
 *
 */
public interface DelivSchedSoldToPartyDetnSelectable extends EntitySelectable<DelivSchedSoldToPartyDetn>
{

}
