/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.field.StandardWorkFmlaParamGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.link.StandardWorkFmlaParamGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable.StandardWorkFmlaParamGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Standard Work Formula Param Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>StandardWorkFmlaParamGroup_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class StandardWorkFmlaParamGroup extends VdmEntity<StandardWorkFmlaParamGroup>
{

    /**
     * Selector for all available fields of StandardWorkFmlaParamGroup.
     *
     */
    public final static StandardWorkFmlaParamGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamGroup</b>
     * </p>
     *
     * @return Standard Value Key
     */
    @Key
    @SerializedName( "StandardWorkFormulaParamGroup" )
    @JsonProperty( "StandardWorkFormulaParamGroup" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamGroup" )
    private String standardWorkFormulaParamGroup;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamGroup</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_GROUP =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamGroup");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFmlaParamGroupDesc</b>
     * </p>
     *
     * @return Text for the standard value key
     */
    @SerializedName( "StandardWorkFmlaParamGroupDesc" )
    @JsonProperty( "StandardWorkFmlaParamGroupDesc" )
    @Nullable
    @ODataField( odataName = "StandardWorkFmlaParamGroupDesc" )
    private String standardWorkFmlaParamGroupDesc;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFmlaParamGroupDesc</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FMLA_PARAM_GROUP_DESC =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFmlaParamGroupDesc");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam1</b>
     * </p>
     *
     * @return Parameter ID
     */
    @SerializedName( "StandardWorkFormulaParam1" )
    @JsonProperty( "StandardWorkFormulaParam1" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParam1" )
    private String standardWorkFormulaParam1;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParam1</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM1 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParam1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName1</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName1" )
    @JsonProperty( "StandardWorkFormulaParamName1" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName1" )
    private String standardWorkFormulaParamName1;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName1</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_NAME1 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamName1");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam2</b>
     * </p>
     *
     * @return Parameter ID
     */
    @SerializedName( "StandardWorkFormulaParam2" )
    @JsonProperty( "StandardWorkFormulaParam2" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParam2" )
    private String standardWorkFormulaParam2;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParam2</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM2 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParam2");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName2</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName2" )
    @JsonProperty( "StandardWorkFormulaParamName2" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName2" )
    private String standardWorkFormulaParamName2;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName2</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_NAME2 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamName2");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam3</b>
     * </p>
     *
     * @return Parameter ID
     */
    @SerializedName( "StandardWorkFormulaParam3" )
    @JsonProperty( "StandardWorkFormulaParam3" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParam3" )
    private String standardWorkFormulaParam3;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParam3</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM3 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParam3");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName3</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName3" )
    @JsonProperty( "StandardWorkFormulaParamName3" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName3" )
    private String standardWorkFormulaParamName3;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName3</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_NAME3 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamName3");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam4</b>
     * </p>
     *
     * @return Parameter ID
     */
    @SerializedName( "StandardWorkFormulaParam4" )
    @JsonProperty( "StandardWorkFormulaParam4" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParam4" )
    private String standardWorkFormulaParam4;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParam4</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM4 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParam4");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName4</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName4" )
    @JsonProperty( "StandardWorkFormulaParamName4" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName4" )
    private String standardWorkFormulaParamName4;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName4</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_NAME4 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamName4");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam5</b>
     * </p>
     *
     * @return Parameter ID
     */
    @SerializedName( "StandardWorkFormulaParam5" )
    @JsonProperty( "StandardWorkFormulaParam5" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParam5" )
    private String standardWorkFormulaParam5;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParam5</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM5 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParam5");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName5</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName5" )
    @JsonProperty( "StandardWorkFormulaParamName5" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName5" )
    private String standardWorkFormulaParamName5;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName5</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_NAME5 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamName5");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam6</b>
     * </p>
     *
     * @return Parameter ID
     */
    @SerializedName( "StandardWorkFormulaParam6" )
    @JsonProperty( "StandardWorkFormulaParam6" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParam6" )
    private String standardWorkFormulaParam6;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParam6</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM6 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParam6");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName6</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName6" )
    @JsonProperty( "StandardWorkFormulaParamName6" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName6" )
    private String standardWorkFormulaParamName6;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName6</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupField<String> STANDARD_WORK_FORMULA_PARAM_NAME6 =
        new StandardWorkFmlaParamGroupField<String>("StandardWorkFormulaParamName6");
    /**
     * Navigation property <b>to_StandardWorkFormulaParam1Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFormulaParamText</b>.
     *
     */
    @SerializedName( "to_StandardWorkFormulaParam1Text" )
    @JsonProperty( "to_StandardWorkFormulaParam1Text" )
    @ODataField( odataName = "to_StandardWorkFormulaParam1Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam1Text;
    /**
     * Navigation property <b>to_StandardWorkFormulaParam2Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFormulaParamText</b>.
     *
     */
    @SerializedName( "to_StandardWorkFormulaParam2Text" )
    @JsonProperty( "to_StandardWorkFormulaParam2Text" )
    @ODataField( odataName = "to_StandardWorkFormulaParam2Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam2Text;
    /**
     * Navigation property <b>to_StandardWorkFormulaParam3Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFormulaParamText</b>.
     *
     */
    @SerializedName( "to_StandardWorkFormulaParam3Text" )
    @JsonProperty( "to_StandardWorkFormulaParam3Text" )
    @ODataField( odataName = "to_StandardWorkFormulaParam3Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam3Text;
    /**
     * Navigation property <b>to_StandardWorkFormulaParam4Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFormulaParamText</b>.
     *
     */
    @SerializedName( "to_StandardWorkFormulaParam4Text" )
    @JsonProperty( "to_StandardWorkFormulaParam4Text" )
    @ODataField( odataName = "to_StandardWorkFormulaParam4Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam4Text;
    /**
     * Navigation property <b>to_StandardWorkFormulaParam5Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFormulaParamText</b>.
     *
     */
    @SerializedName( "to_StandardWorkFormulaParam5Text" )
    @JsonProperty( "to_StandardWorkFormulaParam5Text" )
    @ODataField( odataName = "to_StandardWorkFormulaParam5Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam5Text;
    /**
     * Navigation property <b>to_StandardWorkFormulaParam6Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFormulaParamText</b>.
     *
     */
    @SerializedName( "to_StandardWorkFormulaParam6Text" )
    @JsonProperty( "to_StandardWorkFormulaParam6Text" )
    @ODataField( odataName = "to_StandardWorkFormulaParam6Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam6Text;
    /**
     * Navigation property <b>to_StdWrkFmlaParamGrpTxt</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
     * <b>StandardWorkFmlaParamGrpText</b>.
     *
     */
    @SerializedName( "to_StdWrkFmlaParamGrpTxt" )
    @JsonProperty( "to_StdWrkFmlaParamGrpTxt" )
    @ODataField( odataName = "to_StdWrkFmlaParamGrpTxt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StandardWorkFmlaParamGrpText> toStdWrkFmlaParamGrpTxt;
    /**
     * Use with available fluent helpers to apply the <b>to_StandardWorkFormulaParam1Text</b> navigation property to
     * query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText> TO_STANDARD_WORK_FORMULA_PARAM1_TEXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText>("to_StandardWorkFormulaParam1Text");
    /**
     * Use with available fluent helpers to apply the <b>to_StandardWorkFormulaParam2Text</b> navigation property to
     * query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText> TO_STANDARD_WORK_FORMULA_PARAM2_TEXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText>("to_StandardWorkFormulaParam2Text");
    /**
     * Use with available fluent helpers to apply the <b>to_StandardWorkFormulaParam3Text</b> navigation property to
     * query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText> TO_STANDARD_WORK_FORMULA_PARAM3_TEXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText>("to_StandardWorkFormulaParam3Text");
    /**
     * Use with available fluent helpers to apply the <b>to_StandardWorkFormulaParam4Text</b> navigation property to
     * query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText> TO_STANDARD_WORK_FORMULA_PARAM4_TEXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText>("to_StandardWorkFormulaParam4Text");
    /**
     * Use with available fluent helpers to apply the <b>to_StandardWorkFormulaParam5Text</b> navigation property to
     * query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText> TO_STANDARD_WORK_FORMULA_PARAM5_TEXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText>("to_StandardWorkFormulaParam5Text");
    /**
     * Use with available fluent helpers to apply the <b>to_StandardWorkFormulaParam6Text</b> navigation property to
     * query operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText> TO_STANDARD_WORK_FORMULA_PARAM6_TEXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFormulaParamText>("to_StandardWorkFormulaParam6Text");
    /**
     * Use with available fluent helpers to apply the <b>to_StdWrkFmlaParamGrpTxt</b> navigation property to query
     * operations.
     *
     */
    public final static StandardWorkFmlaParamGroupLink<StandardWorkFmlaParamGrpText> TO_STD_WRK_FMLA_PARAM_GRP_TXT =
        new StandardWorkFmlaParamGroupLink<StandardWorkFmlaParamGrpText>("to_StdWrkFmlaParamGrpTxt");

    @Nonnull
    @Override
    public Class<StandardWorkFmlaParamGroup> getType()
    {
        return StandardWorkFmlaParamGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamGroup</b>
     * </p>
     *
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     */
    public void setStandardWorkFormulaParamGroup( @Nullable final String standardWorkFormulaParamGroup )
    {
        rememberChangedField("StandardWorkFormulaParamGroup", this.standardWorkFormulaParamGroup);
        this.standardWorkFormulaParamGroup = standardWorkFormulaParamGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFmlaParamGroupDesc</b>
     * </p>
     *
     * @param standardWorkFmlaParamGroupDesc
     *            Text for the standard value key
     */
    public void setStandardWorkFmlaParamGroupDesc( @Nullable final String standardWorkFmlaParamGroupDesc )
    {
        rememberChangedField("StandardWorkFmlaParamGroupDesc", this.standardWorkFmlaParamGroupDesc);
        this.standardWorkFmlaParamGroupDesc = standardWorkFmlaParamGroupDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam1</b>
     * </p>
     *
     * @param standardWorkFormulaParam1
     *            Parameter ID
     */
    public void setStandardWorkFormulaParam1( @Nullable final String standardWorkFormulaParam1 )
    {
        rememberChangedField("StandardWorkFormulaParam1", this.standardWorkFormulaParam1);
        this.standardWorkFormulaParam1 = standardWorkFormulaParam1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName1</b>
     * </p>
     *
     * @param standardWorkFormulaParamName1
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName1( @Nullable final String standardWorkFormulaParamName1 )
    {
        rememberChangedField("StandardWorkFormulaParamName1", this.standardWorkFormulaParamName1);
        this.standardWorkFormulaParamName1 = standardWorkFormulaParamName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam2</b>
     * </p>
     *
     * @param standardWorkFormulaParam2
     *            Parameter ID
     */
    public void setStandardWorkFormulaParam2( @Nullable final String standardWorkFormulaParam2 )
    {
        rememberChangedField("StandardWorkFormulaParam2", this.standardWorkFormulaParam2);
        this.standardWorkFormulaParam2 = standardWorkFormulaParam2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName2</b>
     * </p>
     *
     * @param standardWorkFormulaParamName2
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName2( @Nullable final String standardWorkFormulaParamName2 )
    {
        rememberChangedField("StandardWorkFormulaParamName2", this.standardWorkFormulaParamName2);
        this.standardWorkFormulaParamName2 = standardWorkFormulaParamName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam3</b>
     * </p>
     *
     * @param standardWorkFormulaParam3
     *            Parameter ID
     */
    public void setStandardWorkFormulaParam3( @Nullable final String standardWorkFormulaParam3 )
    {
        rememberChangedField("StandardWorkFormulaParam3", this.standardWorkFormulaParam3);
        this.standardWorkFormulaParam3 = standardWorkFormulaParam3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName3</b>
     * </p>
     *
     * @param standardWorkFormulaParamName3
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName3( @Nullable final String standardWorkFormulaParamName3 )
    {
        rememberChangedField("StandardWorkFormulaParamName3", this.standardWorkFormulaParamName3);
        this.standardWorkFormulaParamName3 = standardWorkFormulaParamName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam4</b>
     * </p>
     *
     * @param standardWorkFormulaParam4
     *            Parameter ID
     */
    public void setStandardWorkFormulaParam4( @Nullable final String standardWorkFormulaParam4 )
    {
        rememberChangedField("StandardWorkFormulaParam4", this.standardWorkFormulaParam4);
        this.standardWorkFormulaParam4 = standardWorkFormulaParam4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName4</b>
     * </p>
     *
     * @param standardWorkFormulaParamName4
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName4( @Nullable final String standardWorkFormulaParamName4 )
    {
        rememberChangedField("StandardWorkFormulaParamName4", this.standardWorkFormulaParamName4);
        this.standardWorkFormulaParamName4 = standardWorkFormulaParamName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam5</b>
     * </p>
     *
     * @param standardWorkFormulaParam5
     *            Parameter ID
     */
    public void setStandardWorkFormulaParam5( @Nullable final String standardWorkFormulaParam5 )
    {
        rememberChangedField("StandardWorkFormulaParam5", this.standardWorkFormulaParam5);
        this.standardWorkFormulaParam5 = standardWorkFormulaParam5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName5</b>
     * </p>
     *
     * @param standardWorkFormulaParamName5
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName5( @Nullable final String standardWorkFormulaParamName5 )
    {
        rememberChangedField("StandardWorkFormulaParamName5", this.standardWorkFormulaParamName5);
        this.standardWorkFormulaParamName5 = standardWorkFormulaParamName5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParam6</b>
     * </p>
     *
     * @param standardWorkFormulaParam6
     *            Parameter ID
     */
    public void setStandardWorkFormulaParam6( @Nullable final String standardWorkFormulaParam6 )
    {
        rememberChangedField("StandardWorkFormulaParam6", this.standardWorkFormulaParam6);
        this.standardWorkFormulaParam6 = standardWorkFormulaParam6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName6</b>
     * </p>
     *
     * @param standardWorkFormulaParamName6
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName6( @Nullable final String standardWorkFormulaParamName6 )
    {
        rememberChangedField("StandardWorkFormulaParamName6", this.standardWorkFormulaParamName6);
        this.standardWorkFormulaParamName6 = standardWorkFormulaParamName6;
    }

    @Override
    protected String getEntityCollection()
    {
        return "StandardWorkFmlaParamGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("StandardWorkFormulaParamGroup", getStandardWorkFormulaParamGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("StandardWorkFormulaParamGroup", getStandardWorkFormulaParamGroup());
        values.put("StandardWorkFmlaParamGroupDesc", getStandardWorkFmlaParamGroupDesc());
        values.put("StandardWorkFormulaParam1", getStandardWorkFormulaParam1());
        values.put("StandardWorkFormulaParamName1", getStandardWorkFormulaParamName1());
        values.put("StandardWorkFormulaParam2", getStandardWorkFormulaParam2());
        values.put("StandardWorkFormulaParamName2", getStandardWorkFormulaParamName2());
        values.put("StandardWorkFormulaParam3", getStandardWorkFormulaParam3());
        values.put("StandardWorkFormulaParamName3", getStandardWorkFormulaParamName3());
        values.put("StandardWorkFormulaParam4", getStandardWorkFormulaParam4());
        values.put("StandardWorkFormulaParamName4", getStandardWorkFormulaParamName4());
        values.put("StandardWorkFormulaParam5", getStandardWorkFormulaParam5());
        values.put("StandardWorkFormulaParamName5", getStandardWorkFormulaParamName5());
        values.put("StandardWorkFormulaParam6", getStandardWorkFormulaParam6());
        values.put("StandardWorkFormulaParamName6", getStandardWorkFormulaParamName6());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("StandardWorkFormulaParamGroup") ) {
                final Object value = values.remove("StandardWorkFormulaParamGroup");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamGroup())) ) {
                    setStandardWorkFormulaParamGroup(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFmlaParamGroupDesc") ) {
                final Object value = values.remove("StandardWorkFmlaParamGroupDesc");
                if( (value == null) || (!value.equals(getStandardWorkFmlaParamGroupDesc())) ) {
                    setStandardWorkFmlaParamGroupDesc(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParam1") ) {
                final Object value = values.remove("StandardWorkFormulaParam1");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParam1())) ) {
                    setStandardWorkFormulaParam1(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName1") ) {
                final Object value = values.remove("StandardWorkFormulaParamName1");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName1())) ) {
                    setStandardWorkFormulaParamName1(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParam2") ) {
                final Object value = values.remove("StandardWorkFormulaParam2");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParam2())) ) {
                    setStandardWorkFormulaParam2(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName2") ) {
                final Object value = values.remove("StandardWorkFormulaParamName2");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName2())) ) {
                    setStandardWorkFormulaParamName2(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParam3") ) {
                final Object value = values.remove("StandardWorkFormulaParam3");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParam3())) ) {
                    setStandardWorkFormulaParam3(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName3") ) {
                final Object value = values.remove("StandardWorkFormulaParamName3");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName3())) ) {
                    setStandardWorkFormulaParamName3(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParam4") ) {
                final Object value = values.remove("StandardWorkFormulaParam4");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParam4())) ) {
                    setStandardWorkFormulaParam4(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName4") ) {
                final Object value = values.remove("StandardWorkFormulaParamName4");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName4())) ) {
                    setStandardWorkFormulaParamName4(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParam5") ) {
                final Object value = values.remove("StandardWorkFormulaParam5");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParam5())) ) {
                    setStandardWorkFormulaParam5(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName5") ) {
                final Object value = values.remove("StandardWorkFormulaParamName5");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName5())) ) {
                    setStandardWorkFormulaParamName5(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParam6") ) {
                final Object value = values.remove("StandardWorkFormulaParam6");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParam6())) ) {
                    setStandardWorkFormulaParam6(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName6") ) {
                final Object value = values.remove("StandardWorkFormulaParamName6");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName6())) ) {
                    setStandardWorkFormulaParamName6(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_StandardWorkFormulaParam1Text") ) {
                final Object value = (values).remove("to_StandardWorkFormulaParam1Text");
                if( value instanceof Iterable ) {
                    if( toStandardWorkFormulaParam1Text == null ) {
                        toStandardWorkFormulaParam1Text = Lists.newArrayList();
                    } else {
                        toStandardWorkFormulaParam1Text = Lists.newArrayList(toStandardWorkFormulaParam1Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFormulaParamText entity;
                        if( toStandardWorkFormulaParam1Text.size() > i ) {
                            entity = toStandardWorkFormulaParam1Text.get(i);
                        } else {
                            entity = new StandardWorkFormulaParamText();
                            toStandardWorkFormulaParam1Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StandardWorkFormulaParam2Text") ) {
                final Object value = (values).remove("to_StandardWorkFormulaParam2Text");
                if( value instanceof Iterable ) {
                    if( toStandardWorkFormulaParam2Text == null ) {
                        toStandardWorkFormulaParam2Text = Lists.newArrayList();
                    } else {
                        toStandardWorkFormulaParam2Text = Lists.newArrayList(toStandardWorkFormulaParam2Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFormulaParamText entity;
                        if( toStandardWorkFormulaParam2Text.size() > i ) {
                            entity = toStandardWorkFormulaParam2Text.get(i);
                        } else {
                            entity = new StandardWorkFormulaParamText();
                            toStandardWorkFormulaParam2Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StandardWorkFormulaParam3Text") ) {
                final Object value = (values).remove("to_StandardWorkFormulaParam3Text");
                if( value instanceof Iterable ) {
                    if( toStandardWorkFormulaParam3Text == null ) {
                        toStandardWorkFormulaParam3Text = Lists.newArrayList();
                    } else {
                        toStandardWorkFormulaParam3Text = Lists.newArrayList(toStandardWorkFormulaParam3Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFormulaParamText entity;
                        if( toStandardWorkFormulaParam3Text.size() > i ) {
                            entity = toStandardWorkFormulaParam3Text.get(i);
                        } else {
                            entity = new StandardWorkFormulaParamText();
                            toStandardWorkFormulaParam3Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StandardWorkFormulaParam4Text") ) {
                final Object value = (values).remove("to_StandardWorkFormulaParam4Text");
                if( value instanceof Iterable ) {
                    if( toStandardWorkFormulaParam4Text == null ) {
                        toStandardWorkFormulaParam4Text = Lists.newArrayList();
                    } else {
                        toStandardWorkFormulaParam4Text = Lists.newArrayList(toStandardWorkFormulaParam4Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFormulaParamText entity;
                        if( toStandardWorkFormulaParam4Text.size() > i ) {
                            entity = toStandardWorkFormulaParam4Text.get(i);
                        } else {
                            entity = new StandardWorkFormulaParamText();
                            toStandardWorkFormulaParam4Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StandardWorkFormulaParam5Text") ) {
                final Object value = (values).remove("to_StandardWorkFormulaParam5Text");
                if( value instanceof Iterable ) {
                    if( toStandardWorkFormulaParam5Text == null ) {
                        toStandardWorkFormulaParam5Text = Lists.newArrayList();
                    } else {
                        toStandardWorkFormulaParam5Text = Lists.newArrayList(toStandardWorkFormulaParam5Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFormulaParamText entity;
                        if( toStandardWorkFormulaParam5Text.size() > i ) {
                            entity = toStandardWorkFormulaParam5Text.get(i);
                        } else {
                            entity = new StandardWorkFormulaParamText();
                            toStandardWorkFormulaParam5Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StandardWorkFormulaParam6Text") ) {
                final Object value = (values).remove("to_StandardWorkFormulaParam6Text");
                if( value instanceof Iterable ) {
                    if( toStandardWorkFormulaParam6Text == null ) {
                        toStandardWorkFormulaParam6Text = Lists.newArrayList();
                    } else {
                        toStandardWorkFormulaParam6Text = Lists.newArrayList(toStandardWorkFormulaParam6Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFormulaParamText entity;
                        if( toStandardWorkFormulaParam6Text.size() > i ) {
                            entity = toStandardWorkFormulaParam6Text.get(i);
                        } else {
                            entity = new StandardWorkFormulaParamText();
                            toStandardWorkFormulaParam6Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StdWrkFmlaParamGrpTxt") ) {
                final Object value = (values).remove("to_StdWrkFmlaParamGrpTxt");
                if( value instanceof Iterable ) {
                    if( toStdWrkFmlaParamGrpTxt == null ) {
                        toStdWrkFmlaParamGrpTxt = Lists.newArrayList();
                    } else {
                        toStdWrkFmlaParamGrpTxt = Lists.newArrayList(toStdWrkFmlaParamGrpTxt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StandardWorkFmlaParamGrpText entity;
                        if( toStdWrkFmlaParamGrpTxt.size() > i ) {
                            entity = toStdWrkFmlaParamGrpTxt.get(i);
                        } else {
                            entity = new StandardWorkFmlaParamGrpText();
                            toStdWrkFmlaParamGrpTxt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> StandardWorkFmlaParamGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new StandardWorkFmlaParamGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> StandardWorkFmlaParamGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new StandardWorkFmlaParamGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toStandardWorkFormulaParam1Text != null ) {
            (values).put("to_StandardWorkFormulaParam1Text", toStandardWorkFormulaParam1Text);
        }
        if( toStandardWorkFormulaParam2Text != null ) {
            (values).put("to_StandardWorkFormulaParam2Text", toStandardWorkFormulaParam2Text);
        }
        if( toStandardWorkFormulaParam3Text != null ) {
            (values).put("to_StandardWorkFormulaParam3Text", toStandardWorkFormulaParam3Text);
        }
        if( toStandardWorkFormulaParam4Text != null ) {
            (values).put("to_StandardWorkFormulaParam4Text", toStandardWorkFormulaParam4Text);
        }
        if( toStandardWorkFormulaParam5Text != null ) {
            (values).put("to_StandardWorkFormulaParam5Text", toStandardWorkFormulaParam5Text);
        }
        if( toStandardWorkFormulaParam6Text != null ) {
            (values).put("to_StandardWorkFormulaParam6Text", toStandardWorkFormulaParam6Text);
        }
        if( toStdWrkFmlaParamGrpTxt != null ) {
            (values).put("to_StdWrkFmlaParamGrpTxt", toStdWrkFmlaParamGrpTxt);
        }
        return values;
    }

    /**
     * Fetches the <b>StandardWorkFormulaParamText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StandardWorkFormulaParam1Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFormulaParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> fetchStandardWorkFormulaParam1Text()
    {
        return fetchFieldAsList("to_StandardWorkFormulaParam1Text", StandardWorkFormulaParamText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam1Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam1Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFormulaParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> getStandardWorkFormulaParam1TextOrFetch()
    {
        if( toStandardWorkFormulaParam1Text == null ) {
            toStandardWorkFormulaParam1Text = fetchStandardWorkFormulaParam1Text();
        }
        return toStandardWorkFormulaParam1Text;
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam1Text</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StandardWorkFormulaParam1Text</b> is already loaded, the
     *         result will contain the <b>StandardWorkFormulaParamText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFormulaParamText>> getStandardWorkFormulaParam1TextIfPresent()
    {
        return Option.of(toStandardWorkFormulaParam1Text);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFormulaParamText</b> entities for the loaded navigation property
     * <b>to_StandardWorkFormulaParam1Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam1Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void setStandardWorkFormulaParam1Text( @Nonnull final List<StandardWorkFormulaParamText> value )
    {
        if( toStandardWorkFormulaParam1Text == null ) {
            toStandardWorkFormulaParam1Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam1Text.clear();
        toStandardWorkFormulaParam1Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFormulaParamText</b> entities. This corresponds to the
     * OData navigation property <b>to_StandardWorkFormulaParam1Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam1Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void addStandardWorkFormulaParam1Text( StandardWorkFormulaParamText... entity )
    {
        if( toStandardWorkFormulaParam1Text == null ) {
            toStandardWorkFormulaParam1Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam1Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>StandardWorkFormulaParamText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StandardWorkFormulaParam2Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFormulaParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> fetchStandardWorkFormulaParam2Text()
    {
        return fetchFieldAsList("to_StandardWorkFormulaParam2Text", StandardWorkFormulaParamText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam2Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam2Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFormulaParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> getStandardWorkFormulaParam2TextOrFetch()
    {
        if( toStandardWorkFormulaParam2Text == null ) {
            toStandardWorkFormulaParam2Text = fetchStandardWorkFormulaParam2Text();
        }
        return toStandardWorkFormulaParam2Text;
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam2Text</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StandardWorkFormulaParam2Text</b> is already loaded, the
     *         result will contain the <b>StandardWorkFormulaParamText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFormulaParamText>> getStandardWorkFormulaParam2TextIfPresent()
    {
        return Option.of(toStandardWorkFormulaParam2Text);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFormulaParamText</b> entities for the loaded navigation property
     * <b>to_StandardWorkFormulaParam2Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam2Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void setStandardWorkFormulaParam2Text( @Nonnull final List<StandardWorkFormulaParamText> value )
    {
        if( toStandardWorkFormulaParam2Text == null ) {
            toStandardWorkFormulaParam2Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam2Text.clear();
        toStandardWorkFormulaParam2Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFormulaParamText</b> entities. This corresponds to the
     * OData navigation property <b>to_StandardWorkFormulaParam2Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam2Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void addStandardWorkFormulaParam2Text( StandardWorkFormulaParamText... entity )
    {
        if( toStandardWorkFormulaParam2Text == null ) {
            toStandardWorkFormulaParam2Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam2Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>StandardWorkFormulaParamText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StandardWorkFormulaParam3Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFormulaParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> fetchStandardWorkFormulaParam3Text()
    {
        return fetchFieldAsList("to_StandardWorkFormulaParam3Text", StandardWorkFormulaParamText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam3Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam3Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFormulaParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> getStandardWorkFormulaParam3TextOrFetch()
    {
        if( toStandardWorkFormulaParam3Text == null ) {
            toStandardWorkFormulaParam3Text = fetchStandardWorkFormulaParam3Text();
        }
        return toStandardWorkFormulaParam3Text;
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam3Text</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StandardWorkFormulaParam3Text</b> is already loaded, the
     *         result will contain the <b>StandardWorkFormulaParamText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFormulaParamText>> getStandardWorkFormulaParam3TextIfPresent()
    {
        return Option.of(toStandardWorkFormulaParam3Text);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFormulaParamText</b> entities for the loaded navigation property
     * <b>to_StandardWorkFormulaParam3Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam3Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void setStandardWorkFormulaParam3Text( @Nonnull final List<StandardWorkFormulaParamText> value )
    {
        if( toStandardWorkFormulaParam3Text == null ) {
            toStandardWorkFormulaParam3Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam3Text.clear();
        toStandardWorkFormulaParam3Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFormulaParamText</b> entities. This corresponds to the
     * OData navigation property <b>to_StandardWorkFormulaParam3Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam3Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void addStandardWorkFormulaParam3Text( StandardWorkFormulaParamText... entity )
    {
        if( toStandardWorkFormulaParam3Text == null ) {
            toStandardWorkFormulaParam3Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam3Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>StandardWorkFormulaParamText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StandardWorkFormulaParam4Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFormulaParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> fetchStandardWorkFormulaParam4Text()
    {
        return fetchFieldAsList("to_StandardWorkFormulaParam4Text", StandardWorkFormulaParamText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam4Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam4Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFormulaParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> getStandardWorkFormulaParam4TextOrFetch()
    {
        if( toStandardWorkFormulaParam4Text == null ) {
            toStandardWorkFormulaParam4Text = fetchStandardWorkFormulaParam4Text();
        }
        return toStandardWorkFormulaParam4Text;
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam4Text</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StandardWorkFormulaParam4Text</b> is already loaded, the
     *         result will contain the <b>StandardWorkFormulaParamText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFormulaParamText>> getStandardWorkFormulaParam4TextIfPresent()
    {
        return Option.of(toStandardWorkFormulaParam4Text);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFormulaParamText</b> entities for the loaded navigation property
     * <b>to_StandardWorkFormulaParam4Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam4Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void setStandardWorkFormulaParam4Text( @Nonnull final List<StandardWorkFormulaParamText> value )
    {
        if( toStandardWorkFormulaParam4Text == null ) {
            toStandardWorkFormulaParam4Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam4Text.clear();
        toStandardWorkFormulaParam4Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFormulaParamText</b> entities. This corresponds to the
     * OData navigation property <b>to_StandardWorkFormulaParam4Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam4Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void addStandardWorkFormulaParam4Text( StandardWorkFormulaParamText... entity )
    {
        if( toStandardWorkFormulaParam4Text == null ) {
            toStandardWorkFormulaParam4Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam4Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>StandardWorkFormulaParamText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StandardWorkFormulaParam5Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFormulaParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> fetchStandardWorkFormulaParam5Text()
    {
        return fetchFieldAsList("to_StandardWorkFormulaParam5Text", StandardWorkFormulaParamText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam5Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam5Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFormulaParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> getStandardWorkFormulaParam5TextOrFetch()
    {
        if( toStandardWorkFormulaParam5Text == null ) {
            toStandardWorkFormulaParam5Text = fetchStandardWorkFormulaParam5Text();
        }
        return toStandardWorkFormulaParam5Text;
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam5Text</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StandardWorkFormulaParam5Text</b> is already loaded, the
     *         result will contain the <b>StandardWorkFormulaParamText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFormulaParamText>> getStandardWorkFormulaParam5TextIfPresent()
    {
        return Option.of(toStandardWorkFormulaParam5Text);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFormulaParamText</b> entities for the loaded navigation property
     * <b>to_StandardWorkFormulaParam5Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam5Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void setStandardWorkFormulaParam5Text( @Nonnull final List<StandardWorkFormulaParamText> value )
    {
        if( toStandardWorkFormulaParam5Text == null ) {
            toStandardWorkFormulaParam5Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam5Text.clear();
        toStandardWorkFormulaParam5Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFormulaParamText</b> entities. This corresponds to the
     * OData navigation property <b>to_StandardWorkFormulaParam5Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam5Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void addStandardWorkFormulaParam5Text( StandardWorkFormulaParamText... entity )
    {
        if( toStandardWorkFormulaParam5Text == null ) {
            toStandardWorkFormulaParam5Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam5Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>StandardWorkFormulaParamText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StandardWorkFormulaParam6Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFormulaParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> fetchStandardWorkFormulaParam6Text()
    {
        return fetchFieldAsList("to_StandardWorkFormulaParam6Text", StandardWorkFormulaParamText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam6Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam6Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFormulaParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFormulaParamText> getStandardWorkFormulaParam6TextOrFetch()
    {
        if( toStandardWorkFormulaParam6Text == null ) {
            toStandardWorkFormulaParam6Text = fetchStandardWorkFormulaParam6Text();
        }
        return toStandardWorkFormulaParam6Text;
    }

    /**
     * Retrieval of associated <b>StandardWorkFormulaParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StandardWorkFormulaParam6Text</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StandardWorkFormulaParam6Text</b> is already loaded, the
     *         result will contain the <b>StandardWorkFormulaParamText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFormulaParamText>> getStandardWorkFormulaParam6TextIfPresent()
    {
        return Option.of(toStandardWorkFormulaParam6Text);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFormulaParamText</b> entities for the loaded navigation property
     * <b>to_StandardWorkFormulaParam6Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam6Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void setStandardWorkFormulaParam6Text( @Nonnull final List<StandardWorkFormulaParamText> value )
    {
        if( toStandardWorkFormulaParam6Text == null ) {
            toStandardWorkFormulaParam6Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam6Text.clear();
        toStandardWorkFormulaParam6Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFormulaParamText</b> entities. This corresponds to the
     * OData navigation property <b>to_StandardWorkFormulaParam6Text</b>.
     * <p>
     * If the navigation property <b>to_StandardWorkFormulaParam6Text</b> of a queried <b>StandardWorkFmlaParamGroup</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFormulaParamText</b> entities.
     */
    public void addStandardWorkFormulaParam6Text( StandardWorkFormulaParamText... entity )
    {
        if( toStandardWorkFormulaParam6Text == null ) {
            toStandardWorkFormulaParam6Text = Lists.newArrayList();
        }
        toStandardWorkFormulaParam6Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>StandardWorkFmlaParamGrpText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StdWrkFmlaParamGrpTxt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StandardWorkFmlaParamGrpText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFmlaParamGrpText> fetchStdWrkFmlaParamGrpTxt()
    {
        return fetchFieldAsList("to_StdWrkFmlaParamGrpTxt", StandardWorkFmlaParamGrpText.class);
    }

    /**
     * Retrieval of associated <b>StandardWorkFmlaParamGrpText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StdWrkFmlaParamGrpTxt</b>.
     * <p>
     * If the navigation property <b>to_StdWrkFmlaParamGrpTxt</b> of a queried <b>StandardWorkFmlaParamGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StandardWorkFmlaParamGrpText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StandardWorkFmlaParamGrpText> getStdWrkFmlaParamGrpTxtOrFetch()
    {
        if( toStdWrkFmlaParamGrpTxt == null ) {
            toStdWrkFmlaParamGrpTxt = fetchStdWrkFmlaParamGrpTxt();
        }
        return toStdWrkFmlaParamGrpTxt;
    }

    /**
     * Retrieval of associated <b>StandardWorkFmlaParamGrpText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StdWrkFmlaParamGrpTxt</b>.
     * <p>
     * If the navigation property for an entity <b>StandardWorkFmlaParamGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StdWrkFmlaParamGrpTxt</b> is already loaded, the result
     *         will contain the <b>StandardWorkFmlaParamGrpText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<StandardWorkFmlaParamGrpText>> getStdWrkFmlaParamGrpTxtIfPresent()
    {
        return Option.of(toStdWrkFmlaParamGrpTxt);
    }

    /**
     * Overwrites the list of associated <b>StandardWorkFmlaParamGrpText</b> entities for the loaded navigation property
     * <b>to_StdWrkFmlaParamGrpTxt</b>.
     * <p>
     * If the navigation property <b>to_StdWrkFmlaParamGrpTxt</b> of a queried <b>StandardWorkFmlaParamGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StandardWorkFmlaParamGrpText</b> entities.
     */
    public void setStdWrkFmlaParamGrpTxt( @Nonnull final List<StandardWorkFmlaParamGrpText> value )
    {
        if( toStdWrkFmlaParamGrpTxt == null ) {
            toStdWrkFmlaParamGrpTxt = Lists.newArrayList();
        }
        toStdWrkFmlaParamGrpTxt.clear();
        toStdWrkFmlaParamGrpTxt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StandardWorkFmlaParamGrpText</b> entities. This corresponds to the
     * OData navigation property <b>to_StdWrkFmlaParamGrpTxt</b>.
     * <p>
     * If the navigation property <b>to_StdWrkFmlaParamGrpTxt</b> of a queried <b>StandardWorkFmlaParamGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StandardWorkFmlaParamGrpText</b> entities.
     */
    public void addStdWrkFmlaParamGrpTxt( StandardWorkFmlaParamGrpText... entity )
    {
        if( toStdWrkFmlaParamGrpTxt == null ) {
            toStdWrkFmlaParamGrpTxt = Lists.newArrayList();
        }
        toStdWrkFmlaParamGrpTxt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of StandardWorkFmlaParamGroup instances.
     *
     */
    public final static class StandardWorkFmlaParamGroupBuilder
    {

        private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam1Text = Lists.newArrayList();
        private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam2Text = Lists.newArrayList();
        private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam3Text = Lists.newArrayList();
        private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam4Text = Lists.newArrayList();
        private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam5Text = Lists.newArrayList();
        private List<StandardWorkFormulaParamText> toStandardWorkFormulaParam6Text = Lists.newArrayList();
        private List<StandardWorkFmlaParamGrpText> toStdWrkFmlaParamGrpTxt = Lists.newArrayList();

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStandardWorkFormulaParam1Text(
            final List<StandardWorkFormulaParamText> value )
        {
            toStandardWorkFormulaParam1Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StandardWorkFormulaParam1Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFormulaParamText</b>.
         *
         * @param value
         *            The StandardWorkFormulaParamTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder standardWorkFormulaParam1Text(
            StandardWorkFormulaParamText... value )
        {
            return toStandardWorkFormulaParam1Text(Lists.newArrayList(value));
        }

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStandardWorkFormulaParam2Text(
            final List<StandardWorkFormulaParamText> value )
        {
            toStandardWorkFormulaParam2Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StandardWorkFormulaParam2Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFormulaParamText</b>.
         *
         * @param value
         *            The StandardWorkFormulaParamTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder standardWorkFormulaParam2Text(
            StandardWorkFormulaParamText... value )
        {
            return toStandardWorkFormulaParam2Text(Lists.newArrayList(value));
        }

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStandardWorkFormulaParam3Text(
            final List<StandardWorkFormulaParamText> value )
        {
            toStandardWorkFormulaParam3Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StandardWorkFormulaParam3Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFormulaParamText</b>.
         *
         * @param value
         *            The StandardWorkFormulaParamTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder standardWorkFormulaParam3Text(
            StandardWorkFormulaParamText... value )
        {
            return toStandardWorkFormulaParam3Text(Lists.newArrayList(value));
        }

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStandardWorkFormulaParam4Text(
            final List<StandardWorkFormulaParamText> value )
        {
            toStandardWorkFormulaParam4Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StandardWorkFormulaParam4Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFormulaParamText</b>.
         *
         * @param value
         *            The StandardWorkFormulaParamTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder standardWorkFormulaParam4Text(
            StandardWorkFormulaParamText... value )
        {
            return toStandardWorkFormulaParam4Text(Lists.newArrayList(value));
        }

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStandardWorkFormulaParam5Text(
            final List<StandardWorkFormulaParamText> value )
        {
            toStandardWorkFormulaParam5Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StandardWorkFormulaParam5Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFormulaParamText</b>.
         *
         * @param value
         *            The StandardWorkFormulaParamTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder standardWorkFormulaParam5Text(
            StandardWorkFormulaParamText... value )
        {
            return toStandardWorkFormulaParam5Text(Lists.newArrayList(value));
        }

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStandardWorkFormulaParam6Text(
            final List<StandardWorkFormulaParamText> value )
        {
            toStandardWorkFormulaParam6Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StandardWorkFormulaParam6Text</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFormulaParamText</b>.
         *
         * @param value
         *            The StandardWorkFormulaParamTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder standardWorkFormulaParam6Text(
            StandardWorkFormulaParamText... value )
        {
            return toStandardWorkFormulaParam6Text(Lists.newArrayList(value));
        }

        private StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder toStdWrkFmlaParamGrpTxt(
            final List<StandardWorkFmlaParamGrpText> value )
        {
            toStdWrkFmlaParamGrpTxt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StdWrkFmlaParamGrpTxt</b> for <b>StandardWorkFmlaParamGroup</b> to multiple
         * <b>StandardWorkFmlaParamGrpText</b>.
         *
         * @param value
         *            The StandardWorkFmlaParamGrpTexts to build this StandardWorkFmlaParamGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public StandardWorkFmlaParamGroup.StandardWorkFmlaParamGroupBuilder stdWrkFmlaParamGrpTxt(
            StandardWorkFmlaParamGrpText... value )
        {
            return toStdWrkFmlaParamGrpTxt(Lists.newArrayList(value));
        }

    }

}
