/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable.StandardWorkFmlaParamGroupSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
 * StandardWorkFmlaParamGroup} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class StandardWorkFmlaParamGroupByKeyFluentHelper
    extends
    FluentHelperByKey<StandardWorkFmlaParamGroupByKeyFluentHelper, StandardWorkFmlaParamGroup, StandardWorkFmlaParamGroupSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
     * StandardWorkFmlaParamGroup} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code StandardWorkFmlaParamGroup}
     * @param servicePath
     *            Service path to be used to fetch a single {@code StandardWorkFmlaParamGroup}
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public StandardWorkFmlaParamGroupByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String standardWorkFormulaParamGroup )
    {
        super(servicePath, entityCollection);
        this.key.put("StandardWorkFormulaParamGroup", standardWorkFormulaParamGroup);
    }

    @Override
    @Nonnull
    protected Class<StandardWorkFmlaParamGroup> getEntityClass()
    {
        return StandardWorkFmlaParamGroup.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
