/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.field.StandardWorkFmlaParamGrpTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable.StandardWorkFmlaParamGrpTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Standard Work Formula Param Group Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>StandardWorkFmlaParamGrpText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class StandardWorkFmlaParamGrpText extends VdmEntity<StandardWorkFmlaParamGrpText>
{

    /**
     * Selector for all available fields of StandardWorkFmlaParamGrpText.
     *
     */
    public final static StandardWorkFmlaParamGrpTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamGroup</b>
     * </p>
     *
     * @return Standard Value Key
     */
    @Key
    @SerializedName( "StandardWorkFormulaParamGroup" )
    @JsonProperty( "StandardWorkFormulaParamGroup" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamGroup" )
    private String standardWorkFormulaParamGroup;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamGroup</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGrpTextField<String> STANDARD_WORK_FORMULA_PARAM_GROUP =
        new StandardWorkFmlaParamGrpTextField<String>("StandardWorkFormulaParamGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGrpTextField<String> LANGUAGE =
        new StandardWorkFmlaParamGrpTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFmlaParamGroupDesc</b>
     * </p>
     *
     * @return Text for the standard value key
     */
    @SerializedName( "StandardWorkFmlaParamGroupDesc" )
    @JsonProperty( "StandardWorkFmlaParamGroupDesc" )
    @Nullable
    @ODataField( odataName = "StandardWorkFmlaParamGroupDesc" )
    private String standardWorkFmlaParamGroupDesc;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFmlaParamGroupDesc</b> field to query operations.
     *
     */
    public final static StandardWorkFmlaParamGrpTextField<String> STANDARD_WORK_FMLA_PARAM_GROUP_DESC =
        new StandardWorkFmlaParamGrpTextField<String>("StandardWorkFmlaParamGroupDesc");

    @Nonnull
    @Override
    public Class<StandardWorkFmlaParamGrpText> getType()
    {
        return StandardWorkFmlaParamGrpText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamGroup</b>
     * </p>
     *
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     */
    public void setStandardWorkFormulaParamGroup( @Nullable final String standardWorkFormulaParamGroup )
    {
        rememberChangedField("StandardWorkFormulaParamGroup", this.standardWorkFormulaParamGroup);
        this.standardWorkFormulaParamGroup = standardWorkFormulaParamGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFmlaParamGroupDesc</b>
     * </p>
     *
     * @param standardWorkFmlaParamGroupDesc
     *            Text for the standard value key
     */
    public void setStandardWorkFmlaParamGroupDesc( @Nullable final String standardWorkFmlaParamGroupDesc )
    {
        rememberChangedField("StandardWorkFmlaParamGroupDesc", this.standardWorkFmlaParamGroupDesc);
        this.standardWorkFmlaParamGroupDesc = standardWorkFmlaParamGroupDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "StandardWorkFmlaParamGrpText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("StandardWorkFormulaParamGroup", getStandardWorkFormulaParamGroup());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("StandardWorkFormulaParamGroup", getStandardWorkFormulaParamGroup());
        values.put("Language", getLanguage());
        values.put("StandardWorkFmlaParamGroupDesc", getStandardWorkFmlaParamGroupDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("StandardWorkFormulaParamGroup") ) {
                final Object value = values.remove("StandardWorkFormulaParamGroup");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamGroup())) ) {
                    setStandardWorkFormulaParamGroup(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFmlaParamGroupDesc") ) {
                final Object value = values.remove("StandardWorkFmlaParamGroupDesc");
                if( (value == null) || (!value.equals(getStandardWorkFmlaParamGroupDesc())) ) {
                    setStandardWorkFmlaParamGroupDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> StandardWorkFmlaParamGrpTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new StandardWorkFmlaParamGrpTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> StandardWorkFmlaParamGrpTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new StandardWorkFmlaParamGrpTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService.DEFAULT_SERVICE_PATH);
    }

}
