/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable.StandardWorkFmlaParamGrpTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
 * StandardWorkFmlaParamGrpText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class StandardWorkFmlaParamGrpTextByKeyFluentHelper
    extends
    FluentHelperByKey<StandardWorkFmlaParamGrpTextByKeyFluentHelper, StandardWorkFmlaParamGrpText, StandardWorkFmlaParamGrpTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
     * StandardWorkFmlaParamGrpText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code StandardWorkFmlaParamGrpText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code StandardWorkFmlaParamGrpText}
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public StandardWorkFmlaParamGrpTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String standardWorkFormulaParamGroup,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("StandardWorkFormulaParamGroup", standardWorkFormulaParamGroup);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<StandardWorkFmlaParamGrpText> getEntityClass()
    {
        return StandardWorkFmlaParamGrpText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
