/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.field.StandardWorkFormulaParamTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable.StandardWorkFormulaParamTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Standard Work Formula Param Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>StandardWorkFormulaParamText_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class StandardWorkFormulaParamText extends VdmEntity<StandardWorkFormulaParamText>
{

    /**
     * Selector for all available fields of StandardWorkFormulaParamText.
     *
     */
    public final static StandardWorkFormulaParamTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParameter</b>
     * </p>
     *
     * @return Standard Work Formula Parameter
     */
    @Key
    @SerializedName( "StandardWorkFormulaParameter" )
    @JsonProperty( "StandardWorkFormulaParameter" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParameter" )
    private String standardWorkFormulaParameter;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParameter</b> field to query operations.
     *
     */
    public final static StandardWorkFormulaParamTextField<String> STANDARD_WORK_FORMULA_PARAMETER =
        new StandardWorkFormulaParamTextField<String>("StandardWorkFormulaParameter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static StandardWorkFormulaParamTextField<String> LANGUAGE =
        new StandardWorkFormulaParamTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName</b>
     * </p>
     *
     * @return Standard Work Formula Parameter Name
     */
    @SerializedName( "StandardWorkFormulaParamName" )
    @JsonProperty( "StandardWorkFormulaParamName" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamName" )
    private String standardWorkFormulaParamName;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamName</b> field to query operations.
     *
     */
    public final static StandardWorkFormulaParamTextField<String> STANDARD_WORK_FORMULA_PARAM_NAME =
        new StandardWorkFormulaParamTextField<String>("StandardWorkFormulaParamName");

    @Nonnull
    @Override
    public Class<StandardWorkFormulaParamText> getType()
    {
        return StandardWorkFormulaParamText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParameter</b>
     * </p>
     *
     * @param standardWorkFormulaParameter
     *            Standard Work Formula Parameter
     */
    public void setStandardWorkFormulaParameter( @Nullable final String standardWorkFormulaParameter )
    {
        rememberChangedField("StandardWorkFormulaParameter", this.standardWorkFormulaParameter);
        this.standardWorkFormulaParameter = standardWorkFormulaParameter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamName</b>
     * </p>
     *
     * @param standardWorkFormulaParamName
     *            Standard Work Formula Parameter Name
     */
    public void setStandardWorkFormulaParamName( @Nullable final String standardWorkFormulaParamName )
    {
        rememberChangedField("StandardWorkFormulaParamName", this.standardWorkFormulaParamName);
        this.standardWorkFormulaParamName = standardWorkFormulaParamName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "StandardWorkFormulaParamText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("StandardWorkFormulaParameter", getStandardWorkFormulaParameter());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("StandardWorkFormulaParameter", getStandardWorkFormulaParameter());
        values.put("Language", getLanguage());
        values.put("StandardWorkFormulaParamName", getStandardWorkFormulaParamName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("StandardWorkFormulaParameter") ) {
                final Object value = values.remove("StandardWorkFormulaParameter");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParameter())) ) {
                    setStandardWorkFormulaParameter(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamName") ) {
                final Object value = values.remove("StandardWorkFormulaParamName");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamName())) ) {
                    setStandardWorkFormulaParamName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> StandardWorkFormulaParamTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new StandardWorkFormulaParamTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> StandardWorkFormulaParamTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new StandardWorkFormulaParamTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService.DEFAULT_SERVICE_PATH);
    }

}
