/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable.StandardWorkFormulaParamTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
 * StandardWorkFormulaParamText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class StandardWorkFormulaParamTextByKeyFluentHelper
    extends
    FluentHelperByKey<StandardWorkFormulaParamTextByKeyFluentHelper, StandardWorkFormulaParamText, StandardWorkFormulaParamTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
     * StandardWorkFormulaParamText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code StandardWorkFormulaParamText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code StandardWorkFormulaParamText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param standardWorkFormulaParameter
     *            Standard Work Formula Parameter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public StandardWorkFormulaParamTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String standardWorkFormulaParameter,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("StandardWorkFormulaParameter", standardWorkFormulaParameter);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<StandardWorkFormulaParamText> getEntityClass()
    {
        return StandardWorkFormulaParamText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
