/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link StandardWorkFormulaParameterGroupServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService
 * StandardWorkFormulaParameterGroupService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultStandardWorkFormulaParameterGroupServiceBatch
    extends
    BatchFluentHelperBasic<StandardWorkFormulaParameterGroupServiceBatch, StandardWorkFormulaParameterGroupServiceBatchChangeSet>
    implements
    StandardWorkFormulaParameterGroupServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultStandardWorkFormulaParameterGroupServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultStandardWorkFormulaParameterGroupServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultStandardWorkFormulaParameterGroupServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultStandardWorkFormulaParameterGroupServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultStandardWorkFormulaParameterGroupServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public StandardWorkFormulaParameterGroupServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultStandardWorkFormulaParameterGroupServiceBatchChangeSet(this, service);
    }

}
