/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link StandardWorkFormulaParameterGroupServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService
 * StandardWorkFormulaParameterGroupService}.
 *
 */
public class DefaultStandardWorkFormulaParameterGroupServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<StandardWorkFormulaParameterGroupServiceBatch, StandardWorkFormulaParameterGroupServiceBatchChangeSet>
    implements
    StandardWorkFormulaParameterGroupServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService service;

    @SuppressWarnings( "deprecation" )
    DefaultStandardWorkFormulaParameterGroupServiceBatchChangeSet(
        @Nonnull final DefaultStandardWorkFormulaParameterGroupServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.StandardWorkFormulaParameterGroupService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultStandardWorkFormulaParameterGroupServiceBatchChangeSet getThis()
    {
        return this;
    }

}
