/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
 * StandardWorkFmlaParamGroup}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.field.StandardWorkFmlaParamGroupField
 * StandardWorkFmlaParamGroupField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.link.StandardWorkFmlaParamGroupLink
 * StandardWorkFmlaParamGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_GROUP
 * STANDARD_WORK_FORMULA_PARAM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FMLA_PARAM_GROUP_DESC
 * STANDARD_WORK_FMLA_PARAM_GROUP_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM1
 * STANDARD_WORK_FORMULA_PARAM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_NAME1
 * STANDARD_WORK_FORMULA_PARAM_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM2
 * STANDARD_WORK_FORMULA_PARAM2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_NAME2
 * STANDARD_WORK_FORMULA_PARAM_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM3
 * STANDARD_WORK_FORMULA_PARAM3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_NAME3
 * STANDARD_WORK_FORMULA_PARAM_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM4
 * STANDARD_WORK_FORMULA_PARAM4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_NAME4
 * STANDARD_WORK_FORMULA_PARAM_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM5
 * STANDARD_WORK_FORMULA_PARAM5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_NAME5
 * STANDARD_WORK_FORMULA_PARAM_NAME5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM6
 * STANDARD_WORK_FORMULA_PARAM6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#STANDARD_WORK_FORMULA_PARAM_NAME6
 * STANDARD_WORK_FORMULA_PARAM_NAME6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STANDARD_WORK_FORMULA_PARAM1_TEXT
 * TO_STANDARD_WORK_FORMULA_PARAM1_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STANDARD_WORK_FORMULA_PARAM2_TEXT
 * TO_STANDARD_WORK_FORMULA_PARAM2_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STANDARD_WORK_FORMULA_PARAM3_TEXT
 * TO_STANDARD_WORK_FORMULA_PARAM3_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STANDARD_WORK_FORMULA_PARAM4_TEXT
 * TO_STANDARD_WORK_FORMULA_PARAM4_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STANDARD_WORK_FORMULA_PARAM5_TEXT
 * TO_STANDARD_WORK_FORMULA_PARAM5_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STANDARD_WORK_FORMULA_PARAM6_TEXT
 * TO_STANDARD_WORK_FORMULA_PARAM6_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup#TO_STD_WRK_FMLA_PARAM_GRP_TXT
 * TO_STD_WRK_FMLA_PARAM_GRP_TXT}</li>
 * </ul>
 *
 */
public interface StandardWorkFmlaParamGroupSelectable extends EntitySelectable<StandardWorkFmlaParamGroup>
{

}
