/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
 * StandardWorkFmlaParamGrpText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.field.StandardWorkFmlaParamGrpTextField
 * StandardWorkFmlaParamGrpTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.link.StandardWorkFmlaParamGrpTextLink
 * StandardWorkFmlaParamGrpTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText#STANDARD_WORK_FORMULA_PARAM_GROUP
 * STANDARD_WORK_FORMULA_PARAM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText#STANDARD_WORK_FMLA_PARAM_GROUP_DESC
 * STANDARD_WORK_FMLA_PARAM_GROUP_DESC}</li>
 * </ul>
 *
 */
public interface StandardWorkFmlaParamGrpTextSelectable extends EntitySelectable<StandardWorkFmlaParamGrpText>
{

}
