/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
 * StandardWorkFormulaParamText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.field.StandardWorkFormulaParamTextField
 * StandardWorkFormulaParamTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.link.StandardWorkFormulaParamTextLink
 * StandardWorkFormulaParamTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText#STANDARD_WORK_FORMULA_PARAMETER
 * STANDARD_WORK_FORMULA_PARAMETER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText#STANDARD_WORK_FORMULA_PARAM_NAME
 * STANDARD_WORK_FORMULA_PARAM_NAME}</li>
 * </ul>
 *
 */
public interface StandardWorkFormulaParamTextSelectable extends EntitySelectable<StandardWorkFormulaParamText>
{

}
